/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.progress;

import java.util.concurrent.CancellationException;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import ksp.com.intellij.concurrency.ThreadContext;
import ksp.com.intellij.openapi.application.AccessToken;
import ksp.com.intellij.openapi.progress.CeProcessCanceledException;
import ksp.com.intellij.openapi.progress.ProcessCanceledException;
import ksp.com.intellij.openapi.util.ThrowableComputable;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class Cancellation {
    private static final ThreadLocal<Boolean> isInNonCancelableSection = new ThreadLocal();

    private Cancellation() {
    }

    @VisibleForTesting
    @Nullable
    public static Job currentJob() {
        return (Job)ThreadContext.currentThreadContext().get((CoroutineContext.Key)Job.Key);
    }

    public static void checkCancelled() {
        Job currentJob = Cancellation.currentJob();
        if (currentJob != null) {
            try {
                JobKt.ensureActive((Job)currentJob);
            }
            catch (CancellationException e2) {
                throw new CeProcessCanceledException(e2);
            }
        }
    }

    public static boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            Cancellation.$$$reportNull$$$0(0);
        }
        try {
            if (Cancellation.isInNonCancelableSection()) {
                return computable.compute();
            }
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                T t2 = computable.compute();
                return t2;
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
        catch (ProcessCanceledException e2) {
            throw new RuntimeException("PCE is not expected in non-cancellable section execution", e2);
        }
    }

    @NotNull
    public static AccessToken withNonCancelableSection() {
        if (Cancellation.isInNonCancelableSection()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                Cancellation.$$$reportNull$$$0(1);
            }
            return accessToken;
        }
        isInNonCancelableSection.set(Boolean.TRUE);
        return new AccessToken(){

            @Override
            public void finish() {
                isInNonCancelableSection.remove();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/progress/Cancellation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/progress/Cancellation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withNonCancelableSection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

