/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.filters;

import java.util.List;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.filters.ElementFilter;
import ksp.com.intellij.util.SmartList;

public class OrFilter
implements ElementFilter {
    private final List<ElementFilter> myFilters;

    public OrFilter(ElementFilter ... filters) {
        this.myFilters = new SmartList<ElementFilter>(filters);
    }

    @Override
    public boolean isAcceptable(Object element2, PsiElement context2) {
        return this.myFilters.isEmpty() || this.myFilters.stream().anyMatch(filter -> filter.isAcceptable(element2, context2));
    }

    public boolean isClassAcceptable(Class elementClass) {
        return this.myFilters.isEmpty() || this.myFilters.stream().anyMatch(filter -> filter.isClassAcceptable(elementClass));
    }

    @Override
    public String toString() {
        return '(' + StringUtil.join(this.myFilters, " | ") + ')';
    }
}

