/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.java.stubs;

import java.io.IOException;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.LighterAST;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiField;
import ksp.com.intellij.psi.impl.cache.RecordUtil;
import ksp.com.intellij.psi.impl.cache.TypeInfo;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementType;
import ksp.com.intellij.psi.impl.java.stubs.PsiFieldStub;
import ksp.com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import ksp.com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import ksp.com.intellij.psi.impl.source.PsiEnumConstantImpl;
import ksp.com.intellij.psi.impl.source.PsiFieldImpl;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaDocElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.impl.source.tree.LightTreeUtil;
import ksp.com.intellij.psi.impl.source.tree.java.EnumConstantElement;
import ksp.com.intellij.psi.stubs.IndexSink;
import ksp.com.intellij.psi.stubs.StubElement;
import ksp.com.intellij.psi.stubs.StubInputStream;
import ksp.com.intellij.psi.stubs.StubOutputStream;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NotNull;

public abstract class JavaFieldStubElementType
extends JavaStubElementType<PsiFieldStub, PsiField> {
    private static final int INITIALIZER_LENGTH_LIMIT = 1000;

    public JavaFieldStubElementType(@NotNull String id, @NotNull IElementType parentElementType) {
        if (id == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(0);
        }
        if (parentElementType == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(1);
        }
        super(id, parentElementType);
    }

    @Override
    public PsiField createPsi(@NotNull PsiFieldStub stub2) {
        if (stub2 == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(2);
        }
        return this.getPsiFactory(stub2).createField(stub2);
    }

    @Override
    public PsiField createPsi(@NotNull ASTNode node) {
        if (node == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(3);
        }
        if (node instanceof EnumConstantElement) {
            return new PsiEnumConstantImpl(node);
        }
        return new PsiFieldImpl(node);
    }

    @Override
    @NotNull
    public PsiFieldStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        if (tree == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(4);
        }
        if (node == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(5);
        }
        if (parentStub == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(6);
        }
        TypeInfo typeInfo = TypeInfo.create(tree, node, parentStub);
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String name2 = null;
        String initializer = null;
        boolean expectingInit = false;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type2 = child.getTokenType();
            if (type2 == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type2 == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type2 == JavaTokenType.IDENTIFIER) {
                name2 = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (type2 == JavaTokenType.EQ) {
                expectingInit = true;
                continue;
            }
            if (!expectingInit || ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type2) || type2 == JavaTokenType.SEMICOLON) continue;
            initializer = JavaFieldStubElementType.encodeInitializer(tree, child);
            break;
        }
        boolean isEnumConst = node.getTokenType() == JavaElementType.ENUM_CONSTANT;
        byte flags = PsiFieldStubImpl.packFlags(isEnumConst, isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiFieldStubImpl(parentStub, name2, typeInfo, initializer, flags);
    }

    private static String encodeInitializer(LighterAST tree, LighterASTNode initializer) {
        IElementType type2 = initializer.getTokenType();
        if (type2 == JavaElementType.NEW_EXPRESSION || type2 == JavaElementType.METHOD_CALL_EXPRESSION) {
            return ";INITIALIZER_NOT_STORED;";
        }
        if (initializer.getEndOffset() - initializer.getStartOffset() > 1000) {
            return ";INITIALIZER_TOO_LONG;";
        }
        return LightTreeUtil.toFilteredString(tree, initializer, null);
    }

    @Override
    public void serialize(@NotNull PsiFieldStub stub2, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub2 == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(7);
        }
        if (dataStream == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(8);
        }
        dataStream.writeName(stub2.getName());
        TypeInfo.writeTYPE(dataStream, stub2.getType());
        dataStream.writeName(stub2.getInitializerText());
        dataStream.writeByte(((PsiFieldStubImpl)stub2).getFlags());
    }

    @Override
    @NotNull
    public PsiFieldStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(9);
        }
        String name2 = dataStream.readNameString();
        TypeInfo type2 = TypeInfo.readTYPE(dataStream);
        String initializerText = dataStream.readNameString();
        byte flags = dataStream.readByte();
        return new PsiFieldStubImpl(parentStub, name2, type2, initializerText, flags);
    }

    @Override
    public void indexStub(@NotNull PsiFieldStub stub2, @NotNull IndexSink sink) {
        String name2;
        if (stub2 == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(10);
        }
        if (sink == null) {
            JavaFieldStubElementType.$$$reportNull$$$0(11);
        }
        if ((name2 = stub2.getName()) != null) {
            sink.occurrence(JavaStubIndexKeys.FIELDS, name2);
            if (RecordUtil.isStaticNonPrivateMember(stub2)) {
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, name2);
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, stub2.getType().getShortTypeText());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElementType";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/impl/java/stubs/JavaFieldStubElementType";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createPsi";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "indexStub";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

