/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiAnnotationMemberValue;
import ksp.com.intellij.psi.PsiAnnotationMethod;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.java.stubs.PsiMethodStub;
import ksp.com.intellij.psi.impl.source.PsiMethodImpl;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.reference.SoftReference;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiAnnotationMethodImpl
extends PsiMethodImpl
implements PsiAnnotationMethod {
    private java.lang.ref.SoftReference<PsiAnnotationMemberValue> myCachedDefaultValue;

    public PsiAnnotationMethodImpl(PsiMethodStub stub2) {
        super(stub2, (IStubElementType<?, ?>)JavaStubElementTypes.ANNOTATION_METHOD);
    }

    public PsiAnnotationMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void dropCached() {
        super.dropCached();
        this.myCachedDefaultValue = null;
    }

    @Override
    public PsiAnnotationMemberValue getDefaultValue() {
        PsiMethodStub stub2 = (PsiMethodStub)this.getStub();
        if (stub2 != null) {
            String text = stub2.getDefaultValueText();
            if (StringUtil.isEmpty(text)) {
                return null;
            }
            PsiAnnotationMemberValue value2 = SoftReference.dereference(this.myCachedDefaultValue);
            if (value2 != null) {
                return value2;
            }
            value2 = JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText("@Foo(" + text + ")", this).findAttributeValue(null);
            this.myCachedDefaultValue = new java.lang.ref.SoftReference<PsiAnnotationMemberValue>(value2);
            return value2;
        }
        this.myCachedDefaultValue = null;
        boolean expectedDefault = false;
        for (TreeElement childNode = this.getNode().getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            IElementType type2 = childNode.getElementType();
            if (type2 == JavaTokenType.DEFAULT_KEYWORD) {
                expectedDefault = true;
                continue;
            }
            if (!expectedDefault || !ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(type2)) continue;
            return (PsiAnnotationMemberValue)childNode.getPsi();
        }
        return null;
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiAnnotationMethod:" + this.getName();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiAnnotationMethodImpl.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnnotationMethod(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "ksp/com/intellij/psi/impl/source/PsiAnnotationMethodImpl", "accept"));
    }
}

