/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source;

import java.util.HashMap;
import java.util.Map;
import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiImportList;
import ksp.com.intellij.psi.PsiImportStatement;
import ksp.com.intellij.psi.PsiImportStatementBase;
import ksp.com.intellij.psi.PsiImportStaticStatement;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.java.stubs.PsiImportListStub;
import ksp.com.intellij.psi.impl.source.JavaStubPsiElement;
import ksp.com.intellij.psi.impl.source.PsiImportStatementImpl;
import ksp.com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.JavaElementType;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.tree.TokenSet;
import ksp.com.intellij.util.ArrayUtil;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiImportListImpl
extends JavaStubPsiElement<PsiImportListStub>
implements PsiImportList {
    private volatile Map<String, PsiImportStatement> myClassNameToImportMap;
    private volatile Map<String, PsiImportStatement> myPackageNameToImportMap;
    private volatile Map<String, PsiImportStatementBase> myNameToSingleImportMap;
    private static final TokenSet IMPORT_STATEMENT_BIT_SET = TokenSet.create(JavaElementType.IMPORT_STATEMENT);
    private static final TokenSet IMPORT_STATIC_STATEMENT_BIT_SET = TokenSet.create(JavaElementType.IMPORT_STATIC_STATEMENT);

    public PsiImportListImpl(PsiImportListStub stub2) {
        super(stub2, (IStubElementType)JavaStubElementTypes.IMPORT_LIST);
    }

    public PsiImportListImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiImportListImpl clone2 = (PsiImportListImpl)super.clone();
        clone2.myClassNameToImportMap = null;
        clone2.myPackageNameToImportMap = null;
        clone2.myNameToSingleImportMap = null;
        return clone2;
    }

    @Override
    public void subtreeChanged() {
        this.myClassNameToImportMap = null;
        this.myPackageNameToImportMap = null;
        this.myNameToSingleImportMap = null;
        super.subtreeChanged();
    }

    @Override
    public PsiImportStatement @NotNull [] getImportStatements() {
        PsiImportStatement[] psiImportStatementArray = (PsiImportStatement[])this.getStubOrPsiChildren(IMPORT_STATEMENT_BIT_SET, PsiImportStatementImpl.ARRAY_FACTORY);
        if (psiImportStatementArray == null) {
            PsiImportListImpl.$$$reportNull$$$0(0);
        }
        return psiImportStatementArray;
    }

    @Override
    public PsiImportStaticStatement @NotNull [] getImportStaticStatements() {
        PsiImportStaticStatement[] explicitStaticImports = (PsiImportStaticStatement[])this.getStubOrPsiChildren(IMPORT_STATIC_STATEMENT_BIT_SET, PsiImportStaticStatementImpl.ARRAY_FACTORY);
        PsiImportStaticStatement[] implicitStaticImports = PsiImplUtil.getImplicitStaticImports(this.getContainingFile());
        PsiImportStaticStatement[] psiImportStaticStatementArray = ArrayUtil.mergeArrays(explicitStaticImports, implicitStaticImports);
        if (psiImportStaticStatementArray == null) {
            PsiImportListImpl.$$$reportNull$$$0(1);
        }
        return psiImportStaticStatementArray;
    }

    @Override
    public PsiImportStatementBase @NotNull [] getAllImportStatements() {
        PsiImportStatementBase[] psiImportStatementBaseArray = (PsiImportStatementBase[])this.getStubOrPsiChildren(ElementType.IMPORT_STATEMENT_BASE_BIT_SET, PsiImportStatementBase.ARRAY_FACTORY);
        if (psiImportStatementBaseArray == null) {
            PsiImportListImpl.$$$reportNull$$$0(2);
        }
        return psiImportStatementBaseArray;
    }

    @Override
    public PsiImportStatement findSingleClassImportStatement(String name2) {
        Map<String, PsiImportStatement> map;
        while ((map = this.myClassNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name2);
    }

    @Override
    public PsiImportStatement findOnDemandImportStatement(String name2) {
        Map<String, PsiImportStatement> map;
        while ((map = this.myPackageNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name2);
    }

    @Override
    public PsiImportStatementBase findSingleImportStatement(String name2) {
        Map<String, PsiImportStatementBase> map;
        while ((map = this.myNameToSingleImportMap) == null) {
            this.initializeMaps();
        }
        return map.get(name2);
    }

    @Override
    public boolean isReplaceEquivalent(PsiImportList otherList) {
        return this.getText().equals(otherList.getText());
    }

    private void initializeMaps() {
        PsiImportStaticStatement[] importStatics;
        PsiImportStatement[] imports;
        HashMap<String, PsiImportStatement> classNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatement> packageNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatementBase> nameToSingleImportMap = new HashMap<String, PsiImportStatementBase>();
        for (PsiImportStatement anImport : imports = this.getImportStatements()) {
            String qName = anImport.getQualifiedName();
            if (qName == null) continue;
            if (anImport.isOnDemand()) {
                packageNameToImportMap.put(qName, anImport);
                continue;
            }
            classNameToImportMap.put(qName, anImport);
            PsiJavaCodeReferenceElement importReference = anImport.getImportReference();
            if (importReference == null) continue;
            nameToSingleImportMap.put(importReference.getReferenceName(), anImport);
        }
        for (PsiImportStaticStatement importStatic : importStatics = this.getImportStaticStatements()) {
            String referenceName;
            if (importStatic.isOnDemand() || (referenceName = importStatic.getReferenceName()) == null) continue;
            nameToSingleImportMap.put(referenceName, importStatic);
        }
        this.myClassNameToImportMap = classNameToImportMap;
        this.myPackageNameToImportMap = packageNameToImportMap;
        this.myNameToSingleImportMap = nameToSingleImportMap;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiImportListImpl.$$$reportNull$$$0(3);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitImportList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiImportList";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/PsiImportListImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStaticStatements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImportStatements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/PsiImportListImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

