/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.scope.util;

import java.util.ArrayList;
import java.util.Objects;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.progress.ProgressIndicatorProvider;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaResolveResult;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiCallExpression;
import ksp.com.intellij.psi.PsiCapturedWildcardType;
import ksp.com.intellij.psi.PsiClass;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiDisjunctionType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiEnumConstant;
import ksp.com.intellij.psi.PsiEnumConstantInitializer;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiIdentifier;
import ksp.com.intellij.psi.PsiIntersectionType;
import ksp.com.intellij.psi.PsiInvalidElementAccessException;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiKeyword;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiMethodCallExpression;
import ksp.com.intellij.psi.PsiNewExpression;
import ksp.com.intellij.psi.PsiReferenceExpression;
import ksp.com.intellij.psi.PsiSubstitutor;
import ksp.com.intellij.psi.PsiSuperExpression;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeElement;
import ksp.com.intellij.psi.PsiTypeParameter;
import ksp.com.intellij.psi.PsiVariable;
import ksp.com.intellij.psi.ResolveState;
import ksp.com.intellij.psi.impl.PsiClassImplUtil;
import ksp.com.intellij.psi.impl.source.PsiClassImpl;
import ksp.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import ksp.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import ksp.com.intellij.psi.infos.ClassCandidateInfo;
import ksp.com.intellij.psi.scope.JavaScopeProcessorEvent;
import ksp.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import ksp.com.intellij.psi.scope.NameHint;
import ksp.com.intellij.psi.scope.PsiScopeProcessor;
import ksp.com.intellij.psi.scope.processor.MethodsProcessor;
import ksp.com.intellij.psi.search.GlobalSearchScope;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.psi.util.TypeConversionUtil;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class PsiScopesUtil {
    private static final Logger LOG = Logger.getInstance(PsiScopesUtil.class);

    private PsiScopesUtil() {
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope) {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(0);
        }
        if (entrance == null) {
            PsiScopesUtil.$$$reportNull$$$0(1);
        }
        return PsiScopesUtil.treeWalkUp(processor, entrance, maxScope, ResolveState.initial());
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state) {
        String name2;
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(2);
        }
        if (entrance == null) {
            PsiScopesUtil.$$$reportNull$$$0(3);
        }
        if (state == null) {
            PsiScopesUtil.$$$reportNull$$$0(4);
        }
        if (!entrance.isValid()) {
            LOG.error(new PsiInvalidElementAccessException(entrance));
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        NameHint hint = processor.getHint(NameHint.KEY);
        String string = name2 = hint == null ? null : hint.getName(state);
        while (scope != null) {
            ProgressIndicatorProvider.checkCanceled();
            if (scope instanceof PsiClass) {
                processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, scope);
            }
            if (!scope.processDeclarations(processor, state, prevParent, entrance)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            processor.handleEvent(JavaScopeProcessorEvent.EXIT_LEVEL, scope);
            processor.handleEvent(JavaScopeProcessorEvent.CHANGE_LEVEL, null);
            scope = scope instanceof PsiClassImpl ? ((PsiClassImpl)scope).getContext(name2) : scope.getContext();
        }
        return true;
    }

    public static boolean walkChildrenScopes(@NotNull PsiElement thisElement, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        if (thisElement == null) {
            PsiScopesUtil.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(6);
        }
        if (state == null) {
            PsiScopesUtil.$$$reportNull$$$0(7);
        }
        PsiElement child = null;
        if (lastParent != null && lastParent.getParent() == thisElement && (child = lastParent.getPrevSibling()) == null) {
            return true;
        }
        if (child == null) {
            child = thisElement.getLastChild();
        }
        while (child != null) {
            if (!child.processDeclarations(processor, state, null, place)) {
                return false;
            }
            child = child.getPrevSibling();
        }
        return true;
    }

    public static void processTypeDeclarations(PsiType type2, PsiElement place, PsiScopeProcessor processor) {
        if (type2 instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(place);
            PsiClass arrayClass = JavaPsiFacade.getElementFactory(place.getProject()).getArrayClass(languageLevel);
            PsiTypeParameter[] arrayTypeParameters = arrayClass.getTypeParameters();
            PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
            if (arrayTypeParameters.length > 0) {
                substitutor2 = substitutor2.put(arrayTypeParameters[0], ((PsiArrayType)type2).getComponentType());
            }
            arrayClass.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2), arrayClass, place);
        } else if (type2 instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)type2).getConjuncts()) {
                PsiScopesUtil.processTypeDeclarations(psiType, place, processor);
            }
        } else if (type2 instanceof PsiDisjunctionType) {
            PsiType lub = ((PsiDisjunctionType)type2).getLeastUpperBound();
            PsiScopesUtil.processTypeDeclarations(lub, place, processor);
        } else if (type2 instanceof PsiCapturedWildcardType) {
            PsiType classType = PsiScopesUtil.convertToTypeParameter((PsiCapturedWildcardType)type2, place);
            if (classType != null) {
                PsiScopesUtil.processTypeDeclarations(classType, place, processor);
            }
        } else {
            PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType(type2);
            PsiClass clazz = (PsiClass)result2.getElement();
            if (clazz != null) {
                clazz.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result2.getSubstitutor()), clazz, place);
            }
        }
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope) {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(8);
        }
        if (ref == null) {
            PsiScopesUtil.$$$reportNull$$$0(9);
        }
        return PsiScopesUtil.resolveAndWalk(processor, ref, maxScope, false);
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope, boolean incompleteCode) {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(10);
        }
        if (ref == null) {
            PsiScopesUtil.$$$reportNull$$$0(11);
        }
        PsiElement qualifier2 = ref.getQualifier();
        PsiElement classNameElement = ref.getReferenceNameElement();
        if (classNameElement == null) {
            return true;
        }
        if (qualifier2 != null) {
            PsiElement target = null;
            PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
            if (qualifier2 instanceof PsiExpression || qualifier2 instanceof PsiJavaCodeReferenceElement || qualifier2 instanceof PsiTypeElement) {
                PsiType type2 = null;
                if (qualifier2 instanceof PsiExpression) {
                    type2 = ((PsiExpression)qualifier2).getType();
                    assert (type2 == null || type2.isValid()) : type2.getClass() + "; " + qualifier2;
                    PsiScopesUtil.processTypeDeclarations(type2, ref, processor);
                } else if (qualifier2 instanceof PsiTypeElement) {
                    type2 = ((PsiTypeElement)qualifier2).getType();
                    PsiScopesUtil.processTypeDeclarations(type2, ref, processor);
                }
                if (type2 == null && qualifier2 instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)qualifier2;
                    JavaResolveResult result2 = referenceElement.advancedResolve(incompleteCode);
                    target = result2.getElement();
                    substitutor2 = result2.getSubstitutor();
                    if (target instanceof PsiVariable) {
                        type2 = substitutor2.substitute(((PsiVariable)target).getType());
                        if (type2 instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor2 = substitutor2.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                    } else if (target instanceof PsiMethod) {
                        type2 = substitutor2.substitute(((PsiMethod)target).getReturnType());
                        if (type2 instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor2 = substitutor2.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                        PsiType[] types2 = referenceElement.getTypeParameters();
                        if (target instanceof PsiClass) {
                            substitutor2 = substitutor2.putAll((PsiClass)target, types2);
                        }
                    } else if (target instanceof PsiClass) {
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                    }
                }
            }
            if (target != null) {
                return target.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2), target, ref);
            }
        } else {
            return PsiScopesUtil.treeWalkUp(processor, ref, maxScope);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setupAndRunProcessor(@NotNull MethodsProcessor processor, @NotNull PsiCallExpression call2, boolean dummyImplicitConstructor) throws MethodProcessorSetupFailedException {
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(12);
        }
        if (call2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(13);
        }
        if (call2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)call2;
            PsiReferenceExpression ref = methodCall.getMethodExpression();
            processor.setArgumentList(methodCall.getArgumentList());
            processor.obtainTypeArguments(methodCall);
            if (!ref.isQualified() || ref.getReferenceNameElement() instanceof PsiKeyword) {
                PsiElement referenceNameElement = ref.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                if (referenceNameElement instanceof PsiKeyword) {
                    PsiKeyword keyword = (PsiKeyword)referenceNameElement;
                    if (keyword.getTokenType() == JavaTokenType.THIS_KEYWORD) {
                        PsiClass aClass = JavaResolveUtil.getContextClass(methodCall);
                        if (aClass == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for this expression");
                        }
                        processor.setIsConstructor(true);
                        processor.setAccessClass(aClass);
                        aClass.processDeclarations(processor, ResolveState.initial(), null, call2);
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor, aClass);
                        return;
                    } else if (keyword.getTokenType() == JavaTokenType.SUPER_KEYWORD) {
                        PsiClass aClass = JavaResolveUtil.getContextClass(methodCall);
                        if (aClass == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for super expression");
                        }
                        PsiClass superClass = aClass.getSuperClass();
                        if (superClass == null) return;
                        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
                        PsiClass runSuper = superClass;
                        ArrayList<PsiSubstitutor> contextSubstitutors = new ArrayList<PsiSubstitutor>();
                        do {
                            if (runSuper != null) {
                                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(runSuper, aClass, PsiSubstitutor.EMPTY);
                                contextSubstitutors.add(superSubstitutor);
                            }
                            if (aClass.hasModifierProperty("static")) break;
                            if ((aClass = JavaResolveUtil.getContextClass(aClass)) == null) continue;
                            runSuper = aClass.getSuperClass();
                        } while (aClass != null);
                        for (int i2 = contextSubstitutors.size() - 1; i2 >= 0; --i2) {
                            PsiSubstitutor contextSubstitutor = (PsiSubstitutor)contextSubstitutors.get(i2);
                            substitutor2 = substitutor2.putAll(contextSubstitutor);
                        }
                        processor.setIsConstructor(true);
                        processor.setAccessClass(null);
                        PsiMethod[] constructors2 = superClass.getConstructors();
                        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2);
                        for (PsiMethod constructor : constructors2) {
                            if (processor.execute(constructor, state)) continue;
                            return;
                        }
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor, superClass);
                        return;
                    } else {
                        LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                    }
                    return;
                } else if (referenceNameElement instanceof PsiIdentifier) {
                    processor.setIsConstructor(false);
                    processor.setName(referenceNameElement.getText());
                    processor.setAccessClass(null);
                    PsiScopesUtil.resolveAndWalk(processor, ref, null);
                    return;
                } else {
                    LOG.error("Unknown name element " + referenceNameElement + " in reference " + ref.getText() + "(" + ref + ")");
                }
                return;
            } else {
                PsiElement referenceName = methodCall.getMethodExpression().getReferenceNameElement();
                PsiManager manager = call2.getManager();
                PsiElement qualifier2 = ref.getQualifier();
                if (referenceName == null) {
                    throw new MethodProcessorSetupFailedException("Can't resolve method name for this expression");
                }
                if (referenceName instanceof PsiIdentifier && qualifier2 instanceof PsiExpression) {
                    PsiEnumConstantInitializer initializingClass;
                    PsiElement resolve2;
                    PsiType type2 = ((PsiExpression)qualifier2).getType();
                    if (type2 != null && qualifier2 instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)qualifier2).resolve()) instanceof PsiEnumConstant && (initializingClass = ((PsiEnumConstant)resolve2).getInitializingClass()) != null && PsiScopesUtil.getOverridingMethod(initializingClass, methodCall.getMethodExpression().getReferenceName()) != null) {
                        PsiScopesUtil.processQualifierResult(new ClassCandidateInfo(initializingClass, PsiSubstitutor.EMPTY), processor, methodCall);
                        return;
                    }
                    if (type2 == null) {
                        if (!(qualifier2 instanceof PsiJavaCodeReferenceElement)) throw new MethodProcessorSetupFailedException("Cant determine qualifier type!");
                        JavaResolveResult result2 = ((PsiJavaCodeReferenceElement)qualifier2).advancedResolve(false);
                        if (!(result2.getElement() instanceof PsiClass)) return;
                        processor.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                        PsiScopesUtil.processQualifierResult(result2, processor, methodCall);
                        return;
                    } else if (type2 instanceof PsiDisjunctionType) {
                        PsiScopesUtil.processQualifierType(((PsiDisjunctionType)type2).getLeastUpperBound(), processor, manager, methodCall);
                        return;
                    } else if (type2 instanceof PsiCapturedWildcardType) {
                        PsiType psiType = PsiScopesUtil.convertToTypeParameter((PsiCapturedWildcardType)type2, methodCall);
                        if (psiType == null) return;
                        PsiScopesUtil.processQualifierType(psiType, processor, manager, methodCall);
                        return;
                    } else {
                        PsiScopesUtil.processQualifierType(type2, processor, manager, methodCall);
                    }
                    return;
                } else {
                    LOG.error("ref: " + ref + " (" + ref.getClass() + "), ref.getReferenceNameElement()=" + ref.getReferenceNameElement() + "; methodCall.getMethodExpression().getReferenceNameElement()=" + methodCall.getMethodExpression().getReferenceNameElement() + "; qualifier=" + qualifier2);
                }
            }
            return;
        } else {
            LOG.assertTrue(call2 instanceof PsiNewExpression);
            PsiNewExpression newExpr = (PsiNewExpression)call2;
            PsiJavaCodeReferenceElement classRef = newExpr.getClassOrAnonymousClassReference();
            if (classRef == null) {
                throw new MethodProcessorSetupFailedException("Cant get reference to class in new expression");
            }
            JavaResolveResult result3 = classRef.advancedResolve(false);
            PsiClass aClass = (PsiClass)result3.getElement();
            if (aClass == null) {
                throw new MethodProcessorSetupFailedException("Cant resolve class in new expression");
            }
            processor.setIsConstructor(true);
            processor.setAccessClass(aClass);
            processor.setArgumentList(newExpr.getArgumentList());
            processor.obtainTypeArguments(newExpr);
            aClass.processDeclarations(processor, ResolveState.initial().put(PsiSubstitutor.KEY, result3.getSubstitutor()), null, call2);
            if (!dummyImplicitConstructor) return;
            PsiScopesUtil.processDummyConstructor(processor, aClass);
        }
    }

    private static PsiType convertToTypeParameter(PsiCapturedWildcardType type2, PsiElement methodCall) {
        GlobalSearchScope placeResolveScope = methodCall.getResolveScope();
        PsiType upperBound = PsiClassImplUtil.correctType(type2.getUpperBound(), placeResolveScope);
        while (upperBound instanceof PsiCapturedWildcardType) {
            upperBound = PsiClassImplUtil.correctType(((PsiCapturedWildcardType)upperBound).getUpperBound(), placeResolveScope);
        }
        if (upperBound instanceof PsiArrayType) {
            return upperBound;
        }
        if (upperBound != null) {
            return InferenceSession.createTypeParameterTypeWithUpperBound(upperBound, methodCall);
        }
        return null;
    }

    public static PsiMethod getOverridingMethod(PsiAnonymousClass anonymousClass, String name2) {
        PsiClass baseClass;
        PsiMethod[] refMethods = anonymousClass.findMethodsByName(name2, false);
        if (refMethods.length > 0 && (baseClass = PsiUtil.resolveClassInType(anonymousClass.getBaseClassType())) != null && !PsiScopesUtil.hasCovariantOverridingOrNotPublic(baseClass, refMethods)) {
            for (PsiMethod method : refMethods) {
                if (method.findSuperMethods(baseClass).length <= 0) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean hasCovariantOverridingOrNotPublic(PsiClass baseClass, PsiMethod[] refMethods) {
        for (PsiMethod method : refMethods) {
            PsiType methodReturnType = method.getReturnType();
            for (PsiMethod superMethod : method.findSuperMethods(baseClass)) {
                if (!Comparing.equal(methodReturnType, superMethod.getReturnType())) {
                    return true;
                }
                if (superMethod.hasModifierProperty("public")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean processQualifierType(@NotNull PsiType type2, MethodsProcessor processor, PsiManager manager, PsiMethodCallExpression call2) throws MethodProcessorSetupFailedException {
        if (type2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(14);
        }
        PsiUtil.ensureValidType(type2);
        if (type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult qualifierResult = ((PsiClassType)type2).resolveGenerics();
            return PsiScopesUtil.processQualifierResult(qualifierResult, processor, call2);
        }
        if (type2 instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(call2);
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(manager.getProject());
            PsiClassType.ClassResolveResult qualifierResult = factory2.getArrayClassType(((PsiArrayType)type2).getComponentType(), languageLevel).resolveGenerics();
            return PsiScopesUtil.processQualifierResult(qualifierResult, processor, call2);
        }
        if (type2 instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                if (PsiScopesUtil.processQualifierType(conjunct, processor, manager, call2)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processQualifierResult(@NotNull JavaResolveResult qualifierResult, @NotNull MethodsProcessor processor, @NotNull PsiMethodCallExpression methodCall) throws MethodProcessorSetupFailedException {
        PsiElement resolve2;
        if (qualifierResult == null) {
            PsiScopesUtil.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            PsiScopesUtil.$$$reportNull$$$0(16);
        }
        if (methodCall == null) {
            PsiScopesUtil.$$$reportNull$$$0(17);
        }
        if ((resolve2 = qualifierResult.getElement()) == null) {
            throw new MethodProcessorSetupFailedException("Cant determine qualifier class!");
        }
        if (resolve2 instanceof PsiTypeParameter) {
            processor.setAccessClass((PsiClass)resolve2);
        } else if (resolve2 instanceof PsiClass) {
            PsiExpression qualifier2 = methodCall.getMethodExpression().getQualifierExpression();
            if (!(qualifier2 instanceof PsiSuperExpression)) {
                processor.setAccessClass((PsiClass)PsiUtil.getAccessObjectClass(qualifier2).getElement());
            } else if (((PsiSuperExpression)qualifier2).getQualifier() != null && PsiUtil.isLanguageLevel8OrHigher(qualifier2) && "java.lang.Cloneable".equals(((PsiClass)resolve2).getQualifiedName()) && ((PsiClass)resolve2).isInterface()) {
                processor.setAccessClass((PsiClass)resolve2);
            }
        }
        processor.setIsConstructor(false);
        processor.setName(methodCall.getMethodExpression().getReferenceName());
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, qualifierResult.getSubstitutor());
        return resolve2.processDeclarations(processor, state, methodCall, methodCall);
    }

    private static void processDummyConstructor(MethodsProcessor processor, PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return;
        }
        try {
            PsiMethod[] constructors2 = aClass.getConstructors();
            if (constructors2.length != 0) {
                return;
            }
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(aClass.getProject());
            PsiMethod dummyConstructor = factory2.createConstructor();
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier != null) {
                Objects.requireNonNull(dummyConstructor.getNameIdentifier()).replace(nameIdentifier);
            }
            processor.forceAddResult(dummyConstructor);
        }
        catch (IncorrectOperationException e2) {
            LOG.error(e2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrance";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisElement";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierResult";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/scope/util/PsiScopesUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "treeWalkUp";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "walkChildrenScopes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveAndWalk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "setupAndRunProcessor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processQualifierType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "processQualifierResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

