/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import ksp.com.intellij.openapi.util.SystemInfoRt;
import ksp.com.intellij.util.containers.ConcurrentSoftHashMap;
import ksp.com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import ksp.com.intellij.util.containers.ConcurrentSoftValueHashMap;
import ksp.com.intellij.util.containers.ConcurrentWeakHashMap;
import ksp.com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import ksp.com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import ksp.com.intellij.util.containers.ConcurrentWeakValueHashMap;
import ksp.com.intellij.util.containers.FastUtilHashingStrategies;
import ksp.com.intellij.util.containers.HashingStrategy;
import ksp.com.intellij.util.containers.SoftHashMap;
import ksp.com.intellij.util.containers.SoftKeySoftValueHashMap;
import ksp.com.intellij.util.containers.WeakHashMap;
import ksp.com.intellij.util.containers.WeakKeySoftValueHashMap;
import ksp.com.intellij.util.containers.WeakKeyWeakValueHashMap;
import ksp.it.unimi.dsi.fastutil.Hash;
import ksp.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import ksp.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import ksp.it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import ksp.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import ksp.it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import ksp.it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import ksp.it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import ksp.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import ksp.org.jetbrains.annotations.Contract;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class CollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(0);
        }
        return new ConcurrentWeakHashMap(strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentMap<@NotNull String, @NotNull V> createConcurrentWeakCaseInsensitiveMap() {
        return new ConcurrentWeakHashMap(HashingStrategy.caseInsensitive());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakValueMap() {
        return new ConcurrentWeakValueHashMap(null);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap(null);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakValueMap(@NotNull BiConsumer<? super ConcurrentMap<K, V>, ? super K> evictionListener) {
        if (evictionListener == null) {
            CollectionFactory.$$$reportNull$$$0(1);
        }
        return new ConcurrentWeakValueHashMap(evictionListener);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftValueMap(@NotNull BiConsumer<? super ConcurrentMap<K, V>, ? super K> evictionListener) {
        if (evictionListener == null) {
            CollectionFactory.$$$reportNull$$$0(2);
        }
        return new ConcurrentSoftValueHashMap(evictionListener);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakIdentityMap() {
        return new ConcurrentWeakHashMap(HashingStrategy.identity());
    }

    @Deprecated
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakMap() {
        return new java.util.WeakHashMap();
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(3);
        }
        return new WeakHashMap(initialCapacity, loadFactor, hashingStrategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakKeySoftValueMap() {
        return new WeakKeySoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakKeyWeakValueMap() {
        return new WeakKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftKeySoftValueMap() {
        return new SoftKeySoftValueHashMap();
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueIdentityMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.identity());
    }

    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createWeakIdentityMap(int initialCapacity, float loadFactor) {
        return CollectionFactory.createWeakMap(initialCapacity, loadFactor, HashingStrategy.identity());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(4);
        }
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeyWeakValueIdentityMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.identity());
    }

    @Contract(value="_,_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(5);
        }
        return new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap() {
        return CollectionFactory.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value="_,_,_,_-> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(6);
        }
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new ObjectOpenCustomHashSet<CharSequence>(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(@NotNull List<? extends CharSequence> items) {
        if (items == null) {
            CollectionFactory.$$$reportNull$$$0(7);
        }
        return new ObjectOpenCustomHashSet<CharSequence>(items, FastUtilHashingStrategies.getCharSequenceStrategy(true));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize) {
        return new ObjectOpenCustomHashSet<CharSequence>(expectedSize, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive) {
        return new ObjectOpenCustomHashSet<CharSequence>(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(int capacity, float loadFactory, boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(capacity, loadFactory, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet<String>(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet(@NotNull Collection<String> items) {
        if (items == null) {
            CollectionFactory.$$$reportNull$$$0(8);
        }
        return new ObjectOpenCustomHashSet<String>(items, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet(int initialSize) {
        return new ObjectOpenCustomHashSet<String>(initialSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap(int expectedSize) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap(@NotNull Map<String, V> source) {
        if (source == null) {
            CollectionFactory.$$$reportNull$$$0(9);
        }
        return new Object2ObjectOpenCustomHashMap<String, V>(source, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftKeySoftValueIdentityMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.identity());
    }

    @NotNull
    public static Set<String> createFilePathSet() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new HashSet() : CollectionFactory.createCaseInsensitiveStringSet();
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize) {
        return CollectionFactory.createFilePathSet(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize, boolean isFileSystemCaseSensitive) {
        return isFileSystemCaseSensitive ? new HashSet(expectedSize) : new ObjectOpenCustomHashSet<String>(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths2, boolean isFileSystemCaseSensitive) {
        if (paths2 == null) {
            CollectionFactory.$$$reportNull$$$0(10);
        }
        return isFileSystemCaseSensitive ? new HashSet<String>(paths2) : new ObjectOpenCustomHashSet<String>(paths2, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(String @NotNull [] paths2, boolean isFileSystemCaseSensitive) {
        if (paths2 == null) {
            CollectionFactory.$$$reportNull$$$0(11);
        }
        return isFileSystemCaseSensitive ? new HashSet<String>(Arrays.asList(paths2)) : new ObjectOpenCustomHashSet<String>(paths2, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths2) {
        if (paths2 == null) {
            CollectionFactory.$$$reportNull$$$0(12);
        }
        return CollectionFactory.createFilePathSet(paths2, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new HashMap() : CollectionFactory.createCaseInsensitiveStringMap();
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize) {
        return CollectionFactory.createFilePathMap(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize, boolean isFileSystemCaseSensitive) {
        return isFileSystemCaseSensitive ? new HashMap(expectedSize) : new Object2ObjectOpenCustomHashMap(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathLinkedSet() {
        return SystemInfoRt.isFileSystemCaseSensitive ? CollectionFactory.createSmallMemoryFootprintLinkedSet() : new ObjectLinkedOpenCustomHashSet<String>(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createFilePathLinkedMap() {
        return SystemInfoRt.isFileSystemCaseSensitive ? CollectionFactory.createSmallMemoryFootprintLinkedMap() : new Object2ObjectLinkedOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintLinkedMap() {
        return new Object2ObjectLinkedOpenHashMap();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap() {
        return new Object2ObjectOpenHashMap();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(int expected) {
        return new Object2ObjectOpenHashMap(expected);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(@NotNull Map<? extends K, ? extends V> map) {
        if (map == null) {
            CollectionFactory.$$$reportNull$$$0(13);
        }
        return new Object2ObjectOpenHashMap<K, V>(map);
    }

    @Contract(value="_,_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(int expected, float loadFactor) {
        return new Object2ObjectOpenHashMap(expected, loadFactor);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintLinkedSet() {
        return new ObjectLinkedOpenHashSet();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet() {
        return new ObjectOpenHashSet();
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(int expected) {
        return new ObjectOpenHashSet(expected);
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(@NotNull Collection<? extends K> collection) {
        if (collection == null) {
            CollectionFactory.$$$reportNull$$$0(14);
        }
        return new ObjectOpenHashSet<K>(collection);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull Map<@NotNull K, V> createSoftMap() {
        return new SoftHashMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    static <K, V> @NotNull Map<@NotNull K, V> createSoftMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(15);
        }
        return new SoftHashMap(strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap(null);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap(@NotNull BiConsumer<? super ConcurrentMap<K, V>, ? super V> evictionListener) {
        if (evictionListener == null) {
            CollectionFactory.$$$reportNull$$$0(16);
        }
        return new ConcurrentSoftHashMap(evictionListener);
    }

    @Contract(value="_,_,_,_-> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(17);
        }
        return new ConcurrentSoftHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    public static void trimMap(@NotNull Map<?, ?> map) {
        if (map == null) {
            CollectionFactory.$$$reportNull$$$0(18);
        }
        if (map instanceof Object2ObjectOpenHashMap) {
            ((Object2ObjectOpenHashMap)map).trim();
        } else if (map instanceof Object2ObjectOpenCustomHashMap) {
            ((Object2ObjectOpenCustomHashMap)map).trim();
        }
    }

    public static void trimSet(@NotNull Set<?> set) {
        if (set == null) {
            CollectionFactory.$$$reportNull$$$0(19);
        }
        if (set instanceof ObjectOpenHashSet) {
            ((ObjectOpenHashSet)set).trim();
        } else if (set instanceof ObjectOpenCustomHashSet) {
            ((ObjectOpenCustomHashSet)set).trim();
        }
    }

    @NotNull
    public static <K, V> Map<K, V> createCustomHashingStrategyMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(20);
        }
        return new Object2ObjectOpenCustomHashMap(CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    private static <K> Hash.Strategy<K> adaptStrategy(final @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(21);
        }
        return new FastUtilHashingStrategies.SerializableHashStrategy<K>(){

            @Override
            public int hashCode(@Nullable K o2) {
                return strategy.hashCode(o2);
            }

            @Override
            public boolean equals(@Nullable K a2, @Nullable K b2) {
                return strategy.equals(a2, b2);
            }
        };
    }

    @NotNull
    public static <K, V> Map<K, V> createCustomHashingStrategyMap(int expected, @NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(22);
        }
        return new Object2ObjectOpenCustomHashMap(expected, CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    public static <K> Set<K> createCustomHashingStrategySet(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(23);
        }
        return new ObjectOpenCustomHashSet<K>(CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    public static <K, V> Map<K, V> createLinkedCustomHashingStrategyMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(24);
        }
        return new Object2ObjectLinkedOpenCustomHashMap(CollectionFactory.adaptStrategy(strategy));
    }

    @NotNull
    public static <K> Set<K> createLinkedCustomHashingStrategySet(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(25);
        }
        return new ObjectLinkedOpenCustomHashSet<K>(CollectionFactory.adaptStrategy(strategy));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: 
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evictionListener";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/util/containers/CollectionFactory";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakValueMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentSoftValueMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createWeakMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createCharSequenceSet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaseInsensitiveStringSet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaseInsensitiveStringMap";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createFilePathSet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createSmallMemoryFootprintMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createSmallMemoryFootprintSet";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createSoftMap";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentSoftMap";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "trimMap";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "trimSet";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomHashingStrategyMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "adaptStrategy";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomHashingStrategySet";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "createLinkedCustomHashingStrategyMap";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "createLinkedCustomHashingStrategySet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

