/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import ksp.com.intellij.reference.SoftReference;
import ksp.com.intellij.util.containers.RefValueHashMapUtil;
import ksp.org.jetbrains.annotations.Debug;
import ksp.org.jetbrains.annotations.NotNull;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="childrenArray()")
abstract class RefValueHashMap<K, V>
implements Map<K, V> {
    private final Map<K, MyReference<K, V>> myMap;
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    RefValueHashMap() {
        this.myMap = new HashMap<K, MyReference<K, V>>();
    }

    protected abstract MyReference<K, V> createReference(@NotNull K var1, V var2, @NotNull ReferenceQueue<? super V> var3);

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)((Object)this.myQueue.poll())) != null) {
            Object key = ref.getKey();
            if (this.myMap.get(key) != ref) continue;
            this.myMap.remove(key);
        }
        return;
    }

    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            RefValueHashMap.$$$reportNull$$$0(0);
        }
        MyReference<K, V> ref = this.myMap.get(key);
        return (V)SoftReference.deref(ref);
    }

    @Override
    public V put(@NotNull K key, V value2) {
        if (key == null) {
            RefValueHashMap.$$$reportNull$$$0(1);
        }
        this.processQueue();
        MyReference<K, V> reference2 = this.createReference(key, value2, this.myQueue);
        MyReference<K, V> oldRef = this.myMap.put(key, reference2);
        return (V)SoftReference.deref(oldRef);
    }

    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            RefValueHashMap.$$$reportNull$$$0(2);
        }
        this.processQueue();
        MyReference<K, V> ref = this.myMap.remove(key);
        return (V)SoftReference.deref(ref);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t2) {
        if (t2 == null) {
            RefValueHashMap.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        throw RefValueHashMapUtil.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(Object value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            RefValueHashMap.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result2 = new ArrayList();
        Collection<MyReference<K, V>> refs = this.myMap.values();
        for (MyReference<K, V> ref : refs) {
            Object value2 = ref.get();
            if (value2 == null) continue;
            result2.add(value2);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            RefValueHashMap.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private Map.Entry<K, V>[] childrenArray() {
        return (Map.Entry[])this.myMap.entrySet().stream().map(entry -> {
            Object val = SoftReference.deref((Supplier)entry.getValue());
            return val != null ? new AbstractMap.SimpleImmutableEntry(entry.getKey(), val) : null;
        }).filter(Objects::nonNull).toArray(Map.Entry[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/containers/RefValueHashMap";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/containers/RefValueHashMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface MyReference<K, T>
    extends Supplier<T> {
        @NotNull
        public K getKey();
    }
}

