/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class Stack<T>
extends ArrayList<T> {
    public Stack() {
    }

    public Stack(int initialCapacity) {
        super(initialCapacity);
    }

    public Stack(@NotNull Collection<? extends T> init) {
        if (init == null) {
            Stack.$$$reportNull$$$0(0);
        }
        super(init);
    }

    public Stack(T ... items) {
        if (items == null) {
            Stack.$$$reportNull$$$0(1);
        }
        for (T item : items) {
            this.push(item);
        }
    }

    public void push(T t2) {
        this.add(t2);
    }

    public T peek() {
        int size = this.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return (T)this.get(size - 1);
    }

    public T pop() {
        int size = this.size();
        if (size == 0) {
            throw new EmptyStackException();
        }
        return (T)this.remove(size - 1);
    }

    public int search(Object o2) {
        int idx = this.lastIndexOf(o2);
        return idx == -1 ? -1 : this.size() - idx;
    }

    @Nullable
    public T tryPop() {
        return this.isEmpty() ? null : (T)this.pop();
    }

    public boolean empty() {
        return this.isEmpty();
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof RandomAccess && o2 instanceof List) {
            List other = (List)o2;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i2 = 0; i2 < other.size(); ++i2) {
                Object o22;
                Object o1 = other.get(i2);
                if (Objects.equals(o1, o22 = this.get(i2))) continue;
                return false;
            }
            return true;
        }
        return super.equals(o2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "items";
                break;
            }
        }
        objectArray[1] = "ksp/com/intellij/util/containers/Stack";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

