/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.containers.hash;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import ksp.it.unimi.dsi.fastutil.HashCommon;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class LongLinkedHashMap<V> {
    private static final long NULL_KEY = 0L;
    private Entry<V>[] table;
    private Entry<V> top;
    private Entry<V> back;
    private int capacity;
    private int size;
    private final float loadFactor;
    private final boolean accessOrder;

    public LongLinkedHashMap(int capacity, float loadFactor, boolean accessOrder) {
        this.loadFactor = loadFactor;
        this.clear(capacity);
        this.accessOrder = accessOrder;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.clear(0);
    }

    public V get(long key) {
        Entry<V>[] table = this.table;
        int hash = LongLinkedHashMap.hashCode(key);
        int index2 = hash % table.length;
        Entry e2 = table[index2];
        while (e2 != null) {
            if (e2.keyHash == hash && e2.key == key) {
                this.moveToTop(e2);
                return (V)e2.value;
            }
            e2 = e2.hashNext;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public V put(long key, @NotNull V v2) {
        void value2;
        if (v2 == null) {
            LongLinkedHashMap.$$$reportNull$$$0(0);
        }
        Entry<V>[] table = this.table;
        int hash = LongLinkedHashMap.hashCode(key);
        int index2 = hash % table.length;
        Entry<void> e2 = table[index2];
        while (e2 != null) {
            if (((Entry)e2).keyHash == hash && ((Entry)e2).key == key) {
                this.moveToTop(e2);
                return e2.setValue(value2);
            }
            e2 = ((Entry)e2).hashNext;
        }
        e2 = new Entry<void>(key, value2, hash);
        ((Entry)e2).hashNext = (Entry)table[index2];
        table[index2] = e2;
        Entry<V> top = this.top;
        ((Entry)e2).next = (Entry)top;
        if (top != null) {
            ((Entry)top).previous = (Entry)e2;
        } else {
            this.back = e2;
        }
        this.top = e2;
        ++this.size;
        if (this.removeEldestEntry(this.back)) {
            this.doRemoveEldestEntry();
        } else if (this.size > this.capacity) {
            this.rehash((int)((float)this.capacity * 1.618034f));
        }
        return null;
    }

    public void doRemoveEldestEntry() {
        V val = this.remove(((Entry)this.back).key);
        assert (val != null) : "Entry was not removed. Possibly mutable key: " + Entry.access$200(this.back);
    }

    public boolean containsKey(long key) {
        return this.get(key) != null;
    }

    public V remove(long key) {
        Entry<V>[] table = this.table;
        int hash = LongLinkedHashMap.hashCode(key);
        int index2 = hash % table.length;
        Entry e2 = table[index2];
        if (e2 == null) {
            return null;
        }
        if (e2.keyHash == hash && e2.key == key) {
            table[index2] = e2.hashNext;
        } else {
            Entry last;
            do {
                last = e2;
                if ((e2 = e2.hashNext) != null) continue;
                return null;
            } while (e2.keyHash != hash || e2.key != key);
            last.hashNext = e2.hashNext;
        }
        this.unlink(e2);
        --this.size;
        return (V)e2.value;
    }

    @NotNull
    public Collection<V> values() {
        return new Values();
    }

    protected boolean removeEldestEntry(Entry<V> eldest) {
        return false;
    }

    private void init(int capacity) {
        this.table = new Entry[HashCommon.arraySize(capacity, this.loadFactor)];
        this.back = null;
        this.top = null;
        this.capacity = capacity;
    }

    private void clear(int capacity) {
        if (capacity < 5) {
            capacity = 5;
        }
        this.init(capacity);
        this.size = 0;
    }

    public long getLastKey() {
        return this.top != null ? ((Entry)this.top).key : 0L;
    }

    @Nullable
    public V getLastValue() {
        return (V)(this.top != null ? ((Entry)this.top).value : null);
    }

    public long getFirstKey() {
        return this.back != null ? ((Entry)this.back).key : 0L;
    }

    private void moveToTop(Entry<V> e2) {
        if (!this.accessOrder) {
            return;
        }
        Entry<V> top = this.top;
        if (top != e2) {
            Entry prev = ((Entry)e2).previous;
            Entry next = ((Entry)e2).next;
            prev.next = next;
            if (next != null) {
                next.previous = prev;
            } else {
                this.back = prev;
            }
            ((Entry)top).previous = (Entry)e2;
            ((Entry)e2).next = (Entry)top;
            ((Entry)e2).previous = null;
            this.top = e2;
        }
    }

    private void unlink(Entry<V> e2) {
        Entry prev = ((Entry)e2).previous;
        Entry next = ((Entry)e2).next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.top = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            this.back = prev;
        }
        ((Entry)e2).previous = null;
        ((Entry)e2).next = null;
    }

    private void rehash(int capacity) {
        this.table = new Entry[HashCommon.arraySize(capacity, this.loadFactor)];
        this.capacity = capacity;
        Entry<V>[] table = this.table;
        int tableLen = table.length;
        Entry e2 = this.back;
        while (e2 != null) {
            int hash = e2.keyHash % tableLen;
            e2.hashNext = (Entry)table[hash];
            table[hash] = e2;
            e2 = e2.previous;
        }
    }

    @NotNull
    public Set<Entry<V>> entrySet() {
        return new EntrySet();
    }

    private boolean containsValue(Object value2) {
        for (Entry<V> entry : this.entrySet()) {
            if (!entry.getValue().equals(value2)) continue;
            return true;
        }
        return false;
    }

    private static int hashCode(long value2) {
        return Long.hashCode(value2) & Integer.MAX_VALUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "ksp/com/intellij/util/containers/hash/LongLinkedHashMap", "put"));
    }

    public static final class Entry<V> {
        private final long key;
        private final int keyHash;
        private V value;
        private Entry<V> next;
        private Entry<V> previous;
        private Entry<V> hashNext;

        Entry(long key, V value2, int hash) {
            this.key = key;
            this.keyHash = hash;
            this.value = value2;
        }

        public long getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V value2) {
            V result2 = this.value;
            this.value = value2;
            return result2;
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            return new LinkedHashIterator<V>(){

                @Override
                public V next() {
                    return this.nextEntry().value;
                }
            };
        }

        @Override
        public int size() {
            return LongLinkedHashMap.this.size;
        }

        @Override
        public boolean contains(Object o2) {
            return LongLinkedHashMap.this.containsValue(o2);
        }

        @Override
        public void clear() {
            LongLinkedHashMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractSet<Entry<V>> {
        private EntrySet() {
        }

        @Override
        @NotNull
        public Iterator<Entry<V>> iterator() {
            return new LinkedHashIterator<Entry<V>>(){

                @Override
                public Entry<V> next() {
                    return this.nextEntry();
                }
            };
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Entry)) {
                return false;
            }
            Entry e2 = (Entry)o2;
            Object value2 = LongLinkedHashMap.this.get(e2.getKey());
            return value2 != null && value2.equals(e2.getValue());
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Entry)) {
                return false;
            }
            Entry e2 = (Entry)o2;
            return LongLinkedHashMap.this.remove(e2.getKey()) != null;
        }

        @Override
        public int size() {
            return LongLinkedHashMap.this.size;
        }

        @Override
        public void clear() {
            LongLinkedHashMap.this.clear();
        }
    }

    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        private Entry<V> e;
        private Entry<V> last;

        private LinkedHashIterator() {
            this.e = LongLinkedHashMap.this.back;
        }

        @Override
        public boolean hasNext() {
            return this.e != null;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            LongLinkedHashMap.this.remove(this.last.key);
            this.last = null;
        }

        protected Entry<V> nextEntry() {
            this.last = this.e;
            Entry result2 = this.last;
            this.e = result2.previous;
            return result2;
        }
    }
}

