/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io.pagecache.impl;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import ksp.com.intellij.util.io.pagecache.PagedStorage;

@FunctionalInterface
public interface PageContentLockingStrategy {
    public static final PageContentLockingStrategy LOCK_PER_PAGE = new PageContentLockingStrategy(){

        @Override
        public ReentrantReadWriteLock lockForPage(PagedStorage storage, int pageIndex) {
            return new ReentrantReadWriteLock();
        }

        public String toString() {
            return "LockPerPageLockingStrategy";
        }
    };

    public ReentrantReadWriteLock lockForPage(PagedStorage var1, int var2);

    public static final class SharedLockLockingStrategy
    implements PageContentLockingStrategy {
        private final ReentrantReadWriteLock sharedLock;

        public SharedLockLockingStrategy() {
            this(new ReentrantReadWriteLock());
        }

        public SharedLockLockingStrategy(ReentrantReadWriteLock sharedLock) {
            this.sharedLock = sharedLock;
        }

        @Override
        public ReentrantReadWriteLock lockForPage(PagedStorage storage, int pageIndex) {
            return this.sharedLock;
        }

        public String toString() {
            return "SingleLockLockingStrategy[" + this.sharedLock + "]";
        }
    }
}

