/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io.storage;

import java.io.IOException;
import java.nio.file.Path;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.io.CorruptedException;
import ksp.com.intellij.util.io.PagedFileStorage;
import ksp.com.intellij.util.io.StorageLockContext;
import ksp.com.intellij.util.io.storage.AbstractStorage;
import ksp.com.intellij.util.io.storage.IRecordsTable;
import ksp.com.intellij.util.io.storage.RecordIdIterator;
import ksp.it.unimi.dsi.fastutil.ints.IntArrayList;
import ksp.it.unimi.dsi.fastutil.ints.IntList;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.TestOnly;

public abstract class AbstractRecordsTable
implements IRecordsTable {
    private static final Logger LOG = Logger.getInstance(AbstractRecordsTable.class);
    private static final int HEADER_MAGIC_OFFSET = 0;
    private static final int HEADER_VERSION_OFFSET = 4;
    protected static final int DEFAULT_HEADER_SIZE = 8;
    private static final int VERSION = 5;
    private static final int DIRTY_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190100;
    private static final int ADDRESS_OFFSET = 0;
    private static final int SIZE_OFFSET = 8;
    private static final int CAPACITY_OFFSET = 12;
    protected static final int DEFAULT_RECORD_SIZE = 16;
    protected final PagedFileStorage myStorage;
    private IntList myFreeRecordsList;
    private boolean myIsDirty;
    protected static final int SPECIAL_NEGATIVE_SIZE_FOR_REMOVED_RECORD = -1;

    public AbstractRecordsTable(@NotNull Path storageFilePath, @NotNull StorageLockContext context2) throws IOException {
        if (storageFilePath == null) {
            AbstractRecordsTable.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            AbstractRecordsTable.$$$reportNull$$$0(1);
        }
        this.myFreeRecordsList = null;
        this.myIsDirty = false;
        this.myStorage = new PagedFileStorage(storageFilePath, context2, AbstractRecordsTable.getPageSize(), this.areDataAlignedToPage(), false);
        this.myStorage.lockWrite();
        try {
            if (this.myStorage.length() == 0L) {
                this.myStorage.put(0L, new byte[this.getHeaderSize()], 0, this.getHeaderSize());
                this.markDirty();
            } else if (this.myStorage.getInt(0L) != this.getSafelyClosedMagic()) {
                this.myStorage.close();
                throw new IOException("Records table for '" + storageFilePath + "' haven't been closed correctly. Rebuild required.");
            }
        }
        finally {
            this.myStorage.unlockWrite();
        }
    }

    private static int getPageSize() {
        return AbstractStorage.PAGE_SIZE;
    }

    private boolean areDataAlignedToPage() {
        return (AbstractRecordsTable.getPageSize() - this.getHeaderSize()) % this.getRecordSize() == 0 && AbstractRecordsTable.getPageSize() % this.getRecordSize() == 0;
    }

    private int getSafelyClosedMagic() {
        return 523190100 + this.getImplVersion();
    }

    protected int getHeaderSize() {
        return 8;
    }

    protected abstract int getImplVersion();

    protected abstract int getRecordSize();

    protected abstract byte[] getZeros();

    @Override
    public int createNewRecord() throws IOException {
        this.markDirty();
        this.ensureFreeRecordsScanned();
        int reusedRecord = this.reserveFreeRecord();
        if (reusedRecord == -1) {
            int result2 = this.getRecordsCount() + 1;
            this.doCleanRecord(result2);
            if (this.getRecordsCount() != result2) {
                LOG.error("Failed to correctly allocate new record in: " + this.myStorage);
            }
            return result2;
        }
        assert (AbstractRecordsTable.isSizeOfRemovedRecord(this.getSize(reusedRecord)));
        this.setSize(reusedRecord, 0);
        this.setCapacity(reusedRecord, 0);
        return reusedRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reserveFreeRecord() throws IOException {
        this.ensureFreeRecordsScanned();
        IntList intList = this.myFreeRecordsList;
        synchronized (intList) {
            return this.myFreeRecordsList.isEmpty() ? -1 : this.myFreeRecordsList.removeInt(this.myFreeRecordsList.size() - 1);
        }
    }

    @Override
    public int getRecordsCount() throws IOException {
        int recordsLength = (int)this.myStorage.length() - this.getHeaderSize();
        if (recordsLength % this.getRecordSize() != 0) {
            throw new CorruptedException("Corrupted records: storageLength=" + this.myStorage.length() + " recordsLength=" + recordsLength + " recordSize=" + this.getRecordSize());
        }
        return recordsLength / this.getRecordSize();
    }

    @Override
    public RecordIdIterator createRecordIdIterator() throws IOException {
        return new RecordIdIterator(){
            private final int count;
            private int recordId;
            {
                this.count = AbstractRecordsTable.this.getRecordsCount();
                this.recordId = 1;
            }

            @Override
            public boolean hasNextId() {
                return this.recordId <= this.count;
            }

            @Override
            public int nextId() {
                assert (this.hasNextId());
                return this.recordId++;
            }

            @Override
            public boolean validId() throws IOException {
                assert (this.hasNextId());
                return AbstractRecordsTable.isSizeOfLiveRecord(AbstractRecordsTable.this.getSize(this.recordId));
            }
        };
    }

    @Override
    @TestOnly
    public int getLiveRecordsCount() throws IOException {
        this.ensureFreeRecordsScanned();
        return this.getRecordsCount() - this.myFreeRecordsList.size();
    }

    private void ensureFreeRecordsScanned() throws IOException {
        if (this.myFreeRecordsList == null) {
            this.myFreeRecordsList = this.scanForFreeRecords();
        }
    }

    private IntList scanForFreeRecords() throws IOException {
        IntArrayList result2 = new IntArrayList();
        for (int i2 = 1; i2 <= this.getRecordsCount(); ++i2) {
            if (!AbstractRecordsTable.isSizeOfRemovedRecord(this.getSize(i2))) continue;
            result2.add(i2);
        }
        return result2;
    }

    private void doCleanRecord(int record) throws IOException {
        this.myStorage.put(this.getOffset(record, 0), this.getZeros(), 0, this.getRecordSize());
    }

    @Override
    public long getAddress(int record) throws IOException {
        return this.myStorage.getLong(this.getOffset(record, 0));
    }

    @Override
    public void setAddress(int record, long address) throws IOException {
        this.markDirty();
        this.myStorage.putLong(this.getOffset(record, 0), address);
    }

    @Override
    public int getSize(int record) throws IOException {
        return this.myStorage.getInt(this.getOffset(record, 8));
    }

    @Override
    public void setSize(int record, int size) throws IOException {
        this.markDirty();
        this.myStorage.putInt(this.getOffset(record, 8), size);
    }

    @Override
    public int getCapacity(int record) throws IOException {
        return this.myStorage.getInt(this.getOffset(record, 12));
    }

    @Override
    public void setCapacity(int record, int capacity) throws IOException {
        this.markDirty();
        this.myStorage.putInt(this.getOffset(record, 12), capacity);
    }

    protected int getOffset(int record, int section) {
        assert (record > 0) : "record = " + record;
        int offset = this.getHeaderSize() + (record - 1) * this.getRecordSize() + section;
        if (offset < 0) {
            throw new IllegalArgumentException("offset is negative (" + offset + "): record = " + record + ", section " + section + ", header size " + this.getHeaderSize() + ", record size = " + this.getRecordSize());
        }
        return offset;
    }

    @Override
    public void deleteRecord(int record) throws IOException {
        this.markDirty();
        this.ensureFreeRecordsScanned();
        this.doCleanRecord(record);
        this.setSize(record, -1);
        this.myFreeRecordsList.add(record);
    }

    @Override
    public int getVersion() throws IOException {
        return this.myStorage.getInt(4L);
    }

    @Override
    public void setVersion(int expectedVersion) throws IOException {
        this.markDirty();
        this.myStorage.putInt(4L, expectedVersion);
    }

    @Override
    public void close() throws IOException {
        this.markClean();
        this.myStorage.close();
    }

    @Override
    public void force() throws IOException {
        this.markClean();
        this.myStorage.force();
    }

    @Override
    public boolean isDirty() {
        return this.myIsDirty || this.myStorage.isDirty();
    }

    @Override
    public void markDirty() throws IOException {
        if (!this.myIsDirty) {
            this.myIsDirty = true;
            this.myStorage.putInt(0L, 313341156);
        }
    }

    private void markClean() throws IOException {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.myStorage.putInt(0L, this.getSafelyClosedMagic());
        }
    }

    protected static boolean isSizeOfRemovedRecord(int length) {
        return length == -1;
    }

    protected static boolean isSizeOfLiveRecord(int length) {
        return length != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "storageFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "ksp/com/intellij/util/io/storage/AbstractRecordsTable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

