/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import ksp.com.intellij.diagnostic.ThreadDumper;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.ExceptionUtilRt;
import ksp.com.intellij.util.ReflectionUtil;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.annotations.TestOnly;

public final class EDT {
    private static Thread myEventDispatchThread;
    private static MethodHandle dispatchEventMethod;

    private EDT() {
    }

    @ApiStatus.Internal
    public static void updateEdt() {
        if (myEventDispatchThread != Thread.currentThread()) {
            myEventDispatchThread = Thread.currentThread();
        }
    }

    @ApiStatus.Internal
    public static boolean isEdt(@NotNull Thread thread) {
        if (thread == null) {
            EDT.$$$reportNull$$$0(0);
        }
        return thread == myEventDispatchThread;
    }

    @ApiStatus.Internal
    @NotNull
    public static Thread getEventDispatchThread() {
        Thread thread = myEventDispatchThread;
        if (thread == null) {
            EDT.$$$reportNull$$$0(1);
        }
        return thread;
    }

    @ApiStatus.Internal
    @Nullable
    public static Thread getEventDispatchThreadOrNull() {
        return myEventDispatchThread;
    }

    public static boolean isCurrentThreadEdt() {
        return myEventDispatchThread == null ? EventQueue.isDispatchThread() : EDT.isEdt(Thread.currentThread());
    }

    public static void assertIsEdt() {
        if (!EDT.isCurrentThreadEdt()) {
            Logger.getInstance(EDT.class).error("Assert: must be called on EDT");
        }
    }

    @TestOnly
    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        EDT.assertIsEdt();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        MethodHandle dispatchEventMethod = EDT.dispatchEventMethod;
        if (dispatchEventMethod == null) {
            try {
                Method method = EventQueue.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                method.setAccessible(true);
                dispatchEventMethod = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException | NoSuchMethodException e2) {
                throw new RuntimeException();
            }
            EDT.dispatchEventMethod = dispatchEventMethod;
        }
        boolean threadsDumped = false;
        int i2 = 1;
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (event instanceof InvocationEvent) {
                    dispatchEventMethod.bindTo(eventQueue).invoke(event);
                }
            }
            catch (Throwable e3) {
                ExceptionUtilRt.rethrowUnchecked(e3);
                throw new RuntimeException(e3);
            }
            if (i2 % 10000 == 0) {
                System.out.println("Suspiciously many (" + i2 + ") AWT events, last dispatched " + event);
                if (!threadsDumped) {
                    threadsDumped = true;
                    try {
                        Object application = ReflectionUtil.getMethod(Class.forName("ksp.com.intellij.openapi.application.ApplicationManager"), "getApplication", new Class[0]).invoke(null, new Object[0]);
                        System.err.println("Application=" + application + "\n" + ThreadDumper.dumpThreadsToString());
                    }
                    catch (Exception e4) {
                        throw new RuntimeException(e4);
                    }
                }
            }
            ++i2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/ui/EDT";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/ui/EDT";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDispatchThread";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEdt";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

