/*
 * Decompiled with CFR 0.152.
 */
package ksp.io.opentelemetry.api;

import io.opentelemetry.context.propagation.ContextPropagators;
import ksp.io.opentelemetry.api.DefaultOpenTelemetry;
import ksp.io.opentelemetry.api.logs.LoggerProvider;
import ksp.io.opentelemetry.api.metrics.Meter;
import ksp.io.opentelemetry.api.metrics.MeterBuilder;
import ksp.io.opentelemetry.api.metrics.MeterProvider;
import ksp.io.opentelemetry.api.trace.Tracer;
import ksp.io.opentelemetry.api.trace.TracerBuilder;
import ksp.io.opentelemetry.api.trace.TracerProvider;

public interface OpenTelemetry {
    public static OpenTelemetry noop() {
        return DefaultOpenTelemetry.getNoop();
    }

    public static OpenTelemetry propagating(ContextPropagators propagators) {
        return DefaultOpenTelemetry.getPropagating(propagators);
    }

    public TracerProvider getTracerProvider();

    default public Tracer getTracer(String instrumentationScopeName) {
        return this.getTracerProvider().get(instrumentationScopeName);
    }

    default public Tracer getTracer(String instrumentationScopeName, String instrumentationScopeVersion) {
        return this.getTracerProvider().get(instrumentationScopeName, instrumentationScopeVersion);
    }

    default public TracerBuilder tracerBuilder(String instrumentationScopeName) {
        return this.getTracerProvider().tracerBuilder(instrumentationScopeName);
    }

    default public MeterProvider getMeterProvider() {
        return MeterProvider.noop();
    }

    default public Meter getMeter(String instrumentationScopeName) {
        return this.getMeterProvider().get(instrumentationScopeName);
    }

    default public MeterBuilder meterBuilder(String instrumentationScopeName) {
        return this.getMeterProvider().meterBuilder(instrumentationScopeName);
    }

    default public LoggerProvider getLogsBridge() {
        return LoggerProvider.noop();
    }

    public ContextPropagators getPropagators();
}

