/*
 * Decompiled with CFR 0.152.
 */
package ksp.it.unimi.dsi.fastutil.objects;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import ksp.it.unimi.dsi.fastutil.Arrays;
import ksp.it.unimi.dsi.fastutil.Hash;
import ksp.it.unimi.dsi.fastutil.ints.IntArrays;

public final class ObjectArrays {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Object[] DEFAULT_EMPTY_ARRAY = new Object[0];
    public static final Hash.Strategy HASH_STRATEGY = new a(0);

    private ObjectArrays() {
    }

    private static <K> K[] a(K[] object, int n2) {
        if ((object = object.getClass()) == Object[].class) {
            if (n2 == 0) {
                return EMPTY_ARRAY;
            }
            return new Object[n2];
        }
        return (Object[])Array.newInstance(((Class)object).getComponentType(), n2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> K[] forceCapacity(K[] array, int length, int preserve) {
        void var2_3;
        K[] KArray;
        void var1_1;
        K[] KArray2 = ObjectArrays.a(array, (int)var1_1);
        System.arraycopy(KArray, 0, KArray2, 0, (int)var2_3);
        return KArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static <K> K[] ensureCapacity(K[] array, int length) {
        K[] KArray;
        void var1_1;
        return ObjectArrays.ensureCapacity(array, (int)var1_1, KArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> K[] ensureCapacity(K[] array, int length, int preserve) {
        K[] KArray;
        if (length > array.length) {
            void var2_2;
            void var1_1;
            return ObjectArrays.forceCapacity(array, (int)var1_1, (int)var2_2);
        }
        return KArray;
    }

    /*
     * WARNING - void declaration
     */
    public static <K> K[] grow(K[] array, int length) {
        K[] KArray;
        void var1_1;
        return ObjectArrays.grow(array, (int)var1_1, KArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> K[] grow(K[] array, int length, int preserve) {
        K[] KArray;
        if (length > array.length) {
            void var2_3;
            int n2;
            n2 = (int)Math.max(Math.min((long)array.length + (long)(array.length >> 1), 0x7FFFFFF7L), (long)n2);
            K[] KArray2 = ObjectArrays.a(array, n2);
            System.arraycopy(array, 0, KArray2, 0, (int)var2_3);
            return KArray2;
        }
        return KArray;
    }

    /*
     * WARNING - void declaration
     */
    public static <K> K[] trim(K[] array, int length) {
        void var1_1;
        K[] KArray;
        if (length >= array.length) {
            return array;
        }
        K[] KArray2 = ObjectArrays.a(array, length);
        System.arraycopy(KArray, 0, KArray2, 0, (int)var1_1);
        return KArray2;
    }

    /*
     * WARNING - void declaration
     */
    public static <K> K[] setLength(K[] array, int length) {
        void var1_1;
        K[] KArray;
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return ObjectArrays.trim(array, length);
        }
        return ObjectArrays.ensureCapacity(KArray, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> K[] copy(K[] array, int offset, int length) {
        void var2_2;
        void var1_1;
        K[] KArray;
        ObjectArrays.ensureOffsetLength(array, offset, length);
        K[] KArray2 = ObjectArrays.a(array, length);
        System.arraycopy(KArray, (int)var1_1, KArray2, 0, (int)var2_2);
        return KArray2;
    }

    public static <K> K[] copy(K[] array) {
        return (Object[])array.clone();
    }

    @Deprecated
    public static <K> void fill(K[] array, K value2) {
        int n2 = array.length;
        while (n2-- != 0) {
            array[n2] = value2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <K> void fill(K[] array, int from2, int to, K value2) {
        ObjectArrays.ensureFromTo(array, from2, to);
        if (from2 == 0) {
            while (to-- != 0) {
                array[to] = value2;
            }
        } else {
            void var1_1;
            while (var1_1 < to) {
                array[var1_1] = value2;
                ++var1_1;
            }
        }
    }

    @Deprecated
    public static <K> boolean equals(K[] a1, K[] a2) {
        int n2 = a1.length;
        if (n2 != a2.length) {
            return false;
        }
        while (n2-- != 0) {
            if (Objects.equals(a1[n2], a2[n2])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void ensureFromTo(K[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        Arrays.ensureFromTo(a2.length, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void ensureOffsetLength(K[] a2, int offset, int length) {
        void var2_2;
        void var1_1;
        Arrays.ensureOffsetLength(a2.length, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void ensureSameLength(K[] a2, K[] b2) {
        if (a2.length != b2.length) {
            void var1_1;
            K[] KArray;
            throw new IllegalArgumentException("Array size mismatch: " + KArray.length + " != " + ((void)var1_1).length);
        }
    }

    private static ForkJoinPool a() {
        ForkJoinPool forkJoinPool = ForkJoinTask.getPool();
        if (forkJoinPool == null) {
            return ForkJoinPool.commonPool();
        }
        return forkJoinPool;
    }

    public static <K> void swap(K[] x, int a2, int b2) {
        K k2 = x[a2];
        x[var1_1] = x[b2];
        var0[var2_2] = k2;
    }

    public static <K> void swap(K[] x, int a2, int b2, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            ObjectArrays.swap(x, a2, b2);
            ++n3;
            ++a2;
            ++b2;
        }
    }

    private static <K> int b(K[] KArray, int n2, int n3, int n4, Comparator<K> comparator) {
        int n5 = comparator.compare(KArray[n2], KArray[n3]);
        int n6 = comparator.compare(KArray[n2], KArray[n4]);
        int n7 = comparator.compare(KArray[n3], KArray[n4]);
        if (n5 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n6 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n6 > 0) {
            return n4;
        }
        return n2;
    }

    public static <K> void quickSort(K[] x, int from2, int to, Comparator<K> comp) {
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = to - from2) < 16) {
                while (from2 < to - 1) {
                    n4 = from2;
                    for (n3 = from2 + 1; n3 < to; ++n3) {
                        if (comp.compare(x[n3], x[n4]) >= 0) continue;
                        n4 = n3;
                    }
                    if (n4 != from2) {
                        K k2 = x[from2];
                        x[from2] = x[n4];
                        x[n4] = k2;
                    }
                    ++from2;
                }
                return;
            }
            n3 = from2 + n4 / 2;
            int n5 = from2;
            int n6 = to - 1;
            if (n4 > 128) {
                int n7 = from2;
                n5 = ObjectArrays.b(x, n7, n7 + (n4 /= 8), from2 + 2 * n4, comp);
                int n8 = n3;
                n3 = ObjectArrays.b(x, n3 - n4, n8, n8 + n4, comp);
                n6 = ObjectArrays.b(x, n6 - 2 * n4, n6 - n4, n6, comp);
            }
            n3 = ObjectArrays.b(x, n5, n3, n6, comp);
            K k3 = x[n3];
            n3 = from2;
            n5 = from2;
            int n9 = n6 = to - 1;
            while (true) {
                if (n5 <= n6 && (n2 = comp.compare(x[n5], k3)) <= 0) {
                    if (n2 == 0) {
                        ObjectArrays.swap(x, n3++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = comp.compare(x[n6], k3)) >= 0) {
                    if (n2 == 0) {
                        ObjectArrays.swap(x, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                ObjectArrays.swap(x, n5++, n6--);
            }
            n2 = Math.min(n3 - from2, n5 - n3);
            ObjectArrays.swap(x, from2, n5 - n2, n2);
            n2 = Math.min(n9 - n6, to - n9 - 1);
            ObjectArrays.swap(x, n5, to - n2, n2);
            n2 = n5 - n3;
            if (n2 > 1) {
                int n10 = from2;
                ObjectArrays.quickSort(x, n10, n10 + n2, comp);
            }
            if ((n2 = n9 - n6) <= 1) break;
            from2 = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void quickSort(K[] x, Comparator<K> comp) {
        void var1_1;
        K[] KArray;
        ObjectArrays.quickSort(x, 0, KArray.length, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void parallelQuickSort(K[] x, int from2, int to, Comparator<K> comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        K[] KArray;
        ForkJoinPool forkJoinPool = ObjectArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            ObjectArrays.quickSort(x, from2, to, comp);
            return;
        }
        forkJoinPool.invoke(new d<K>(KArray, (int)var1_1, (int)var2_2, var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void parallelQuickSort(K[] x, Comparator<K> comp) {
        void var1_1;
        K[] KArray;
        ObjectArrays.parallelQuickSort(x, 0, KArray.length, var1_1);
    }

    private static <K> int b(K[] KArray, int n2, int n3, int n4) {
        int n5 = ((Comparable)KArray[n2]).compareTo(KArray[n3]);
        int n6 = ((Comparable)KArray[n2]).compareTo(KArray[n4]);
        int n7 = ((Comparable)KArray[n3]).compareTo(KArray[n4]);
        if (n5 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n6 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n6 > 0) {
            return n4;
        }
        return n2;
    }

    public static <K> void quickSort(K[] x, int from2, int to) {
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = to - from2) < 16) {
                while (from2 < to - 1) {
                    n4 = from2;
                    for (n3 = from2 + 1; n3 < to; ++n3) {
                        if (((Comparable)x[n3]).compareTo(x[n4]) >= 0) continue;
                        n4 = n3;
                    }
                    if (n4 != from2) {
                        K k2 = x[from2];
                        x[from2] = x[n4];
                        x[n4] = k2;
                    }
                    ++from2;
                }
                return;
            }
            n3 = from2 + n4 / 2;
            int n5 = from2;
            int n6 = to - 1;
            if (n4 > 128) {
                int n7 = from2;
                n5 = ObjectArrays.b(x, n7, n7 + (n4 /= 8), from2 + 2 * n4);
                int n8 = n3;
                n3 = ObjectArrays.b(x, n3 - n4, n8, n8 + n4);
                n6 = ObjectArrays.b(x, n6 - 2 * n4, n6 - n4, n6);
            }
            n3 = ObjectArrays.b(x, n5, n3, n6);
            K k3 = x[n3];
            n3 = from2;
            n5 = from2;
            int n9 = n6 = to - 1;
            while (true) {
                if (n5 <= n6 && (n2 = ((Comparable)x[n5]).compareTo(k3)) <= 0) {
                    if (n2 == 0) {
                        ObjectArrays.swap(x, n3++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = ((Comparable)x[n6]).compareTo(k3)) >= 0) {
                    if (n2 == 0) {
                        ObjectArrays.swap(x, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                ObjectArrays.swap(x, n5++, n6--);
            }
            n2 = Math.min(n3 - from2, n5 - n3);
            ObjectArrays.swap(x, from2, n5 - n2, n2);
            n2 = Math.min(n9 - n6, to - n9 - 1);
            ObjectArrays.swap(x, n5, to - n2, n2);
            n2 = n5 - n3;
            if (n2 > 1) {
                int n10 = from2;
                ObjectArrays.quickSort(x, n10, n10 + n2);
            }
            if ((n2 = n9 - n6) <= 1) break;
            from2 = to - n2;
        }
    }

    public static <K> void quickSort(K[] x) {
        K[] KArray;
        ObjectArrays.quickSort(x, 0, KArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void parallelQuickSort(K[] x, int from2, int to) {
        void var2_2;
        void var1_1;
        K[] KArray;
        ForkJoinPool forkJoinPool = ObjectArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            ObjectArrays.quickSort(x, from2, to);
            return;
        }
        forkJoinPool.invoke(new b<K>(KArray, (int)var1_1, (int)var2_2));
    }

    public static <K> void parallelQuickSort(K[] x) {
        K[] KArray;
        ObjectArrays.parallelQuickSort(x, 0, KArray.length);
    }

    private static <K> int b(int[] object, K[] KArray, int n2, int n3, int n4) {
        K k2 = KArray[object[n2]];
        K k3 = KArray[object[n3]];
        object = KArray[object[n4]];
        int n5 = ((Comparable)k2).compareTo(k3);
        int n6 = ((Comparable)k2).compareTo(object);
        int n7 = ((Comparable)k3).compareTo(object);
        if (n5 < 0) {
            if (n7 < 0) {
                return n3;
            }
            if (n6 < 0) {
                return n4;
            }
            return n2;
        }
        if (n7 > 0) {
            return n3;
        }
        if (n6 > 0) {
            return n4;
        }
        return n2;
    }

    public static <K> void quickSortIndirect(int[] perm, K[] x, int from2, int to) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if ((n6 = to - from2) < 16) {
                n6 = from2;
                while (++n6 < to) {
                    n5 = perm[n6];
                    n4 = n6;
                    n3 = perm[n4 - 1];
                    while (((Comparable)x[n5]).compareTo(x[n3]) < 0) {
                        perm[n4] = n3;
                        if (from2 == n4 - 1) {
                            --n4;
                            break;
                        }
                        n3 = perm[--n4 - 1];
                    }
                    perm[n4] = n5;
                }
                return;
            }
            n5 = from2 + n6 / 2;
            n4 = from2;
            n3 = to - 1;
            if (n6 > 128) {
                int n7 = from2;
                n4 = ObjectArrays.b(perm, x, n7, n7 + (n6 /= 8), from2 + 2 * n6);
                int n8 = n5;
                n5 = ObjectArrays.b(perm, x, n5 - n6, n8, n8 + n6);
                n3 = ObjectArrays.b(perm, x, n3 - 2 * n6, n3 - n6, n3);
            }
            n5 = ObjectArrays.b(perm, x, n4, n5, n3);
            K k2 = x[perm[n5]];
            n5 = from2;
            n4 = from2;
            int n9 = n3 = to - 1;
            while (true) {
                if (n4 <= n3 && (n2 = ((Comparable)x[perm[n4]]).compareTo(k2)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(perm, n5++, n4);
                    }
                    ++n4;
                    continue;
                }
                while (n3 >= n4 && (n2 = ((Comparable)x[perm[n3]]).compareTo(k2)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(perm, n3, n9--);
                    }
                    --n3;
                }
                if (n4 > n3) break;
                IntArrays.swap(perm, n4++, n3--);
            }
            n2 = Math.min(n5 - from2, n4 - n5);
            IntArrays.swap(perm, from2, n4 - n2, n2);
            n2 = Math.min(n9 - n3, to - n9 - 1);
            IntArrays.swap(perm, n4, to - n2, n2);
            n2 = n4 - n5;
            if (n2 > 1) {
                int n10 = from2;
                ObjectArrays.quickSortIndirect(perm, x, n10, n10 + n2);
            }
            if ((n2 = n9 - n3) <= 1) break;
            from2 = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void quickSortIndirect(int[] perm, K[] x) {
        void var1_1;
        ObjectArrays.quickSortIndirect(perm, x, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void parallelQuickSortIndirect(int[] perm, K[] x, int from2, int to) {
        void var3_3;
        void var2_2;
        void var1_1;
        int[] nArray;
        ForkJoinPool forkJoinPool = ObjectArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            ObjectArrays.quickSortIndirect(perm, x, from2, to);
            return;
        }
        forkJoinPool.invoke(new e(nArray, (K[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void parallelQuickSortIndirect(int[] perm, K[] x) {
        void var1_1;
        ObjectArrays.parallelQuickSortIndirect(perm, x, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void stabilize(int[] perm, K[] x, int from2, int to) {
        void var2_2;
        int n2 = from2;
        ++var2_2;
        while (var2_2 < to) {
            if (x[perm[var2_2]] != x[perm[n2]]) {
                if (var2_2 - n2 > true) {
                    IntArrays.parallelQuickSort(perm, n2, (int)var2_2);
                }
                n2 = var2_2;
            }
            ++var2_2;
        }
        if (to - n2 > 1) {
            void var3_3;
            int[] nArray;
            IntArrays.parallelQuickSort(nArray, n2, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void stabilize(int[] perm, K[] x) {
        int[] nArray;
        void var1_1;
        ObjectArrays.stabilize(perm, var1_1, 0, nArray.length);
    }

    private static <K> int c(K[] KArray, K[] KArray2, int n2, int n3, int n4) {
        int n5;
        int n6 = ((Comparable)KArray[n2]).compareTo(KArray[n3]);
        int n7 = n6 == 0 ? ((Comparable)KArray2[n2]).compareTo(KArray2[n3]) : n6;
        n6 = ((Comparable)KArray[n2]).compareTo(KArray[n4]);
        int n8 = n6 == 0 ? ((Comparable)KArray2[n2]).compareTo(KArray2[n4]) : n6;
        n6 = ((Comparable)KArray[n3]).compareTo(KArray[n4]);
        int n9 = n5 = n6 == 0 ? ((Comparable)KArray2[n3]).compareTo(KArray2[n4]) : n6;
        if (n7 < 0) {
            if (n5 < 0) {
                return n3;
            }
            if (n8 < 0) {
                return n4;
            }
            return n2;
        }
        if (n5 > 0) {
            return n3;
        }
        if (n8 > 0) {
            return n4;
        }
        return n2;
    }

    private static <K> void b(K[] KArray, K[] KArray2, int n2, int n3) {
        K k2 = KArray[n2];
        K k3 = KArray2[n2];
        KArray[n2] = KArray[n3];
        KArray2[n2] = KArray2[n3];
        KArray[n3] = k2;
        KArray2[n3] = k3;
    }

    private static <K> void d(K[] KArray, K[] KArray2, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            ObjectArrays.b(KArray, KArray2, n2, n3);
            ++n5;
            ++n2;
            ++n3;
        }
    }

    public static <K> void quickSort(K[] x, K[] y, int from2, int to) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5;
            if ((n5 = to - from2) < 16) {
                while (from2 < to - 1) {
                    n5 = from2;
                    for (n4 = from2 + 1; n4 < to; ++n4) {
                        int n6 = ((Comparable)x[n4]).compareTo(x[n5]);
                        if (n6 >= 0 && (n6 != 0 || ((Comparable)y[n4]).compareTo(y[n5]) >= 0)) continue;
                        n5 = n4;
                    }
                    if (n5 != from2) {
                        K k2 = x[from2];
                        x[from2] = x[n5];
                        x[n5] = k2;
                        k2 = y[from2];
                        y[from2] = y[n5];
                        y[n5] = k2;
                    }
                    ++from2;
                }
                return;
            }
            int n7 = from2 + n5 / 2;
            n4 = from2;
            int n8 = to - 1;
            if (n5 > 128) {
                int n9 = from2;
                n4 = ObjectArrays.c(x, y, n9, n9 + (n5 /= 8), from2 + 2 * n5);
                int n10 = n7;
                n7 = ObjectArrays.c(x, y, n7 - n5, n10, n10 + n5);
                n8 = ObjectArrays.c(x, y, n8 - 2 * n5, n8 - n5, n8);
            }
            n7 = ObjectArrays.c(x, y, n4, n7, n8);
            K k3 = x[n7];
            K k4 = y[n7];
            n4 = from2;
            n8 = from2;
            int n11 = n3 = to - 1;
            while (true) {
                if (n8 <= n3 && (n2 = (n2 = ((Comparable)x[n8]).compareTo(k3)) == 0 ? ((Comparable)y[n8]).compareTo(k4) : n2) <= 0) {
                    if (n2 == 0) {
                        ObjectArrays.b(x, y, n4++, n8);
                    }
                    ++n8;
                    continue;
                }
                while (n3 >= n8 && (n2 = (n2 = ((Comparable)x[n3]).compareTo(k3)) == 0 ? ((Comparable)y[n3]).compareTo(k4) : n2) >= 0) {
                    if (n2 == 0) {
                        ObjectArrays.b(x, y, n3, n11--);
                    }
                    --n3;
                }
                if (n8 > n3) break;
                ObjectArrays.b(x, y, n8++, n3--);
            }
            n2 = Math.min(n4 - from2, n8 - n4);
            ObjectArrays.d(x, y, from2, n8 - n2, n2);
            n2 = Math.min(n11 - n3, to - n11 - 1);
            ObjectArrays.d(x, y, n8, to - n2, n2);
            n2 = n8 - n4;
            if (n2 > 1) {
                int n12 = from2;
                ObjectArrays.quickSort(x, y, n12, n12 + n2);
            }
            if ((n2 = n11 - n3) <= 1) break;
            from2 = to - n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void quickSort(K[] x, K[] y) {
        K[] KArray;
        void var1_1;
        ObjectArrays.ensureSameLength(x, y);
        ObjectArrays.quickSort(x, var1_1, 0, KArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void parallelQuickSort(K[] x, K[] y, int from2, int to) {
        void var3_3;
        void var2_2;
        void var1_1;
        K[] KArray;
        ForkJoinPool forkJoinPool = ObjectArrays.a();
        if (to - from2 < 8192 || forkJoinPool.getParallelism() == 1) {
            ObjectArrays.quickSort(x, y, from2, to);
            return;
        }
        forkJoinPool.invoke(new c<K>(KArray, (K[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void parallelQuickSort(K[] x, K[] y) {
        K[] KArray;
        void var1_1;
        ObjectArrays.ensureSameLength(x, y);
        ObjectArrays.parallelQuickSort(x, var1_1, 0, KArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void unstableSort(K[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        ObjectArrays.quickSort(a2, (int)var1_1, (int)var2_2);
    }

    public static <K> void unstableSort(K[] a2) {
        K[] KArray;
        ObjectArrays.unstableSort(a2, 0, KArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void unstableSort(K[] a2, int from2, int to, Comparator<K> comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectArrays.quickSort(a2, (int)var1_1, (int)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void unstableSort(K[] a2, Comparator<K> comp) {
        void var1_1;
        K[] KArray;
        ObjectArrays.unstableSort(a2, 0, KArray.length, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void mergeSort(K[] a2, int from2, int to, K[] supp22) {
        K[] supp22;
        int n2 = to - from2;
        if (n2 < 16) {
            int supp22 = from2;
            while (++supp22 < to) {
                K k2 = a2[supp22];
                int n3 = supp22;
                K k3 = a2[n3 - 1];
                while (((Comparable)k2).compareTo(k3) < 0) {
                    a2[n3] = k3;
                    if (from2 == n3 - 1) {
                        --n3;
                        break;
                    }
                    k3 = a2[--n3 - 1];
                }
                a2[n3] = k2;
            }
            return;
        }
        if (supp22 == null) {
            supp22 = java.util.Arrays.copyOf(a2, to);
        }
        int n4 = from2 + to >>> 1;
        ObjectArrays.mergeSort(supp22, from2, n4, a2);
        ObjectArrays.mergeSort(supp22, n4, to, a2);
        if (((Comparable)supp22[n4 - 1]).compareTo(supp22[n4]) <= 0) {
            System.arraycopy(supp22, from2, a2, from2, n2);
            return;
        }
        int n5 = n4;
        for (n2 = from2; n2 < to; ++n2) {
            void var1_1;
            a2[n2] = n5 >= to || var1_1 < n4 && ((Comparable)supp22[var1_1]).compareTo(supp22[n5]) <= 0 ? supp22[++var1_1] : supp22[n5++];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void mergeSort(K[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        ObjectArrays.mergeSort(a2, (int)var1_1, (int)var2_2, null);
    }

    public static <K> void mergeSort(K[] a2) {
        K[] KArray;
        ObjectArrays.mergeSort(a2, 0, KArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void mergeSort(K[] a2, int from2, int to, Comparator<K> comp, K[] supp22) {
        K[] supp22;
        int n2 = to - from2;
        if (n2 < 16) {
            int supp22 = from2;
            while (++supp22 < to) {
                K k2 = a2[supp22];
                int n3 = supp22;
                K k3 = a2[n3 - 1];
                while (comp.compare(k2, k3) < 0) {
                    a2[n3] = k3;
                    if (from2 == n3 - 1) {
                        --n3;
                        break;
                    }
                    k3 = a2[--n3 - 1];
                }
                a2[n3] = k2;
            }
            return;
        }
        if (supp22 == null) {
            supp22 = java.util.Arrays.copyOf(a2, to);
        }
        int n4 = from2 + to >>> 1;
        ObjectArrays.mergeSort(supp22, from2, n4, comp, a2);
        ObjectArrays.mergeSort(supp22, n4, to, comp, a2);
        if (comp.compare(supp22[n4 - 1], supp22[n4]) <= 0) {
            System.arraycopy(supp22, from2, a2, from2, n2);
            return;
        }
        int n5 = n4;
        for (n2 = from2; n2 < to; ++n2) {
            void var1_1;
            a2[n2] = n5 >= to || var1_1 < n4 && comp.compare(supp22[var1_1], supp22[n5]) <= 0 ? supp22[++var1_1] : supp22[n5++];
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void mergeSort(K[] a2, int from2, int to, Comparator<K> comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectArrays.mergeSort(a2, (int)var1_1, (int)var2_2, var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void mergeSort(K[] a2, Comparator<K> comp) {
        void var1_1;
        K[] KArray;
        ObjectArrays.mergeSort(a2, 0, KArray.length, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void stableSort(K[] a2, int from2, int to) {
        void var2_2;
        void var1_1;
        java.util.Arrays.sort(a2, (int)var1_1, (int)var2_2);
    }

    public static <K> void stableSort(K[] a2) {
        K[] KArray;
        ObjectArrays.stableSort(a2, 0, KArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void stableSort(K[] a2, int from2, int to, Comparator<K> comp) {
        void var3_3;
        void var2_2;
        void var1_1;
        java.util.Arrays.sort(a2, (int)var1_1, (int)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> void stableSort(K[] a2, Comparator<K> comp) {
        void var1_1;
        K[] KArray;
        ObjectArrays.stableSort(a2, 0, KArray.length, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> int binarySearch(K[] a2, int from2, int to, K key) {
        void var1_1;
        --to;
        while (from2 <= to) {
            int n2 = from2 + to >>> 1;
            int n3 = ((Comparable)a2[n2]).compareTo(key);
            if (n3 < 0) {
                from2 = n2 + 1;
                continue;
            }
            if (n3 > 0) {
                to = n2 - 1;
                continue;
            }
            return n2;
        }
        return (int)(-(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static <K> int binarySearch(K[] a2, K key) {
        void var1_1;
        K[] KArray;
        return ObjectArrays.binarySearch(a2, 0, KArray.length, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> int binarySearch(K[] a2, int from2, int to, K key, Comparator<K> c2) {
        void var1_1;
        --to;
        while (from2 <= to) {
            int n2 = from2 + to >>> 1;
            K k2 = a2[n2];
            int n3 = c2.compare(k2, key);
            if (n3 < 0) {
                from2 = n2 + 1;
                continue;
            }
            if (n3 > 0) {
                to = n2 - 1;
                continue;
            }
            return n2;
        }
        return (int)(-(var1_1 + true));
    }

    /*
     * WARNING - void declaration
     */
    public static <K> int binarySearch(K[] a2, K key, Comparator<K> c2) {
        void var2_2;
        void var1_1;
        K[] KArray;
        return ObjectArrays.binarySearch(a2, 0, KArray.length, var1_1, var2_2);
    }

    public static <K> K[] shuffle(K[] a2, int from2, int to, Random random) {
        K[] KArray;
        int n2 = to - from2;
        while (n2-- != 0) {
            int n3 = random.nextInt(n2 + 1);
            K k2 = a2[from2 + n2];
            a2[from2 + n2] = a2[from2 + n3];
            a2[from2 + n3] = k2;
        }
        return KArray;
    }

    public static <K> K[] shuffle(K[] a2, Random random) {
        K[] KArray;
        int n2 = a2.length;
        while (n2-- != 0) {
            int n3 = random.nextInt(n2 + 1);
            K k2 = a2[n2];
            a2[n2] = a2[n3];
            a2[n3] = k2;
        }
        return KArray;
    }

    public static <K> K[] reverse(K[] a2) {
        K[] KArray;
        int n2 = a2.length;
        int n3 = n2 / 2;
        while (n3-- != 0) {
            K k2 = a2[n2 - n3 - 1];
            a2[n2 - n3 - 1] = a2[n3];
            a2[n3] = k2;
        }
        return KArray;
    }

    public static <K> K[] reverse(K[] a2, int from2, int to) {
        K[] KArray;
        int n2 = to - from2;
        int n3 = n2 / 2;
        while (n3-- != 0) {
            K k2 = a2[from2 + n2 - n3 - 1];
            a2[from2 + n2 - n3 - 1] = a2[from2 + n3];
            a2[from2 + n3] = k2;
        }
        return KArray;
    }

    protected static final class d<K>
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final K[] c;
        private final Comparator<K> d;

        public d(K[] KArray, int n2, int n3, Comparator<K> comparator) {
            this.a = n2;
            this.b = n3;
            this.c = KArray;
            this.d = comparator;
        }

        @Override
        protected final void compute() {
            int n2;
            Object[] objectArray = this.c;
            int n3 = this.b - this.a;
            if (n3 < 8192) {
                ObjectArrays.quickSort(objectArray, this.a, this.b, this.d);
                return;
            }
            int n4 = this.a + n3 / 2;
            int n5 = this.a;
            int n6 = this.b - 1;
            int n7 = n5;
            n5 = ObjectArrays.b(objectArray, n7, n7 + (n3 /= 8), n5 + 2 * n3, this.d);
            int n8 = n4;
            n4 = ObjectArrays.b(objectArray, n4 - n3, n8, n8 + n3, this.d);
            n6 = ObjectArrays.b(objectArray, n6 - 2 * n3, n6 - n3, n6, this.d);
            n4 = ObjectArrays.b(objectArray, n5, n4, n6, this.d);
            Object object = objectArray[n4];
            n5 = n4 = this.a;
            int n9 = n6 = this.b - 1;
            while (true) {
                if (n5 <= n6 && (n2 = this.d.compare(objectArray[n5], object)) <= 0) {
                    if (n2 == 0) {
                        ObjectArrays.swap(objectArray, n4++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = this.d.compare(objectArray[n6], object)) >= 0) {
                    if (n2 == 0) {
                        ObjectArrays.swap(objectArray, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                ObjectArrays.swap(objectArray, n5++, n6--);
            }
            int n10 = Math.min(n4 - this.a, n5 - n4);
            ObjectArrays.swap(objectArray, this.a, n5 - n10, n10);
            n10 = Math.min(n9 - n6, this.b - n9 - 1);
            ObjectArrays.swap(objectArray, n5, this.b - n10, n10);
            n10 = n5 - n4;
            n2 = n9 - n6;
            if (n10 > 1 && n2 > 1) {
                ksp.it.unimi.dsi.fastutil.objects.ObjectArrays$d.invokeAll(new d<Object>(objectArray, this.a, this.a + n10, this.d), new d<Object>(objectArray, this.b - n2, this.b, this.d));
                return;
            }
            if (n10 > 1) {
                ksp.it.unimi.dsi.fastutil.objects.ObjectArrays$d.invokeAll(new d<Object>(objectArray, this.a, this.a + n10, this.d));
                return;
            }
            ksp.it.unimi.dsi.fastutil.objects.ObjectArrays$d.invokeAll(new d<Object>(objectArray, this.b - n2, this.b, this.d));
        }
    }

    protected static final class b<K>
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final K[] c;

        public b(K[] KArray, int n2, int n3) {
            this.a = n2;
            this.b = n3;
            this.c = KArray;
        }

        @Override
        protected final void compute() {
            int n2;
            Object[] objectArray = this.c;
            int n3 = this.b - this.a;
            if (n3 < 8192) {
                ObjectArrays.quickSort(objectArray, this.a, this.b);
                return;
            }
            int n4 = this.a + n3 / 2;
            int n5 = this.a;
            int n6 = this.b - 1;
            int n7 = n5;
            n5 = ObjectArrays.b(objectArray, n7, n7 + (n3 /= 8), n5 + 2 * n3);
            int n8 = n4;
            n4 = ObjectArrays.b(objectArray, n4 - n3, n8, n8 + n3);
            n6 = ObjectArrays.b(objectArray, n6 - 2 * n3, n6 - n3, n6);
            n4 = ObjectArrays.b(objectArray, n5, n4, n6);
            Object object = objectArray[n4];
            n5 = n4 = this.a;
            int n9 = n6 = this.b - 1;
            while (true) {
                if (n5 <= n6 && (n2 = ((Comparable)objectArray[n5]).compareTo(object)) <= 0) {
                    if (n2 == 0) {
                        ObjectArrays.swap(objectArray, n4++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = ((Comparable)objectArray[n6]).compareTo(object)) >= 0) {
                    if (n2 == 0) {
                        ObjectArrays.swap(objectArray, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                ObjectArrays.swap(objectArray, n5++, n6--);
            }
            int n10 = Math.min(n4 - this.a, n5 - n4);
            ObjectArrays.swap(objectArray, this.a, n5 - n10, n10);
            n10 = Math.min(n9 - n6, this.b - n9 - 1);
            ObjectArrays.swap(objectArray, n5, this.b - n10, n10);
            n10 = n5 - n4;
            n2 = n9 - n6;
            if (n10 > 1 && n2 > 1) {
                ksp.it.unimi.dsi.fastutil.objects.ObjectArrays$b.invokeAll(new b<Object>(objectArray, this.a, this.a + n10), new b<Object>(objectArray, this.b - n2, this.b));
                return;
            }
            if (n10 > 1) {
                ksp.it.unimi.dsi.fastutil.objects.ObjectArrays$b.invokeAll(new b<Object>(objectArray, this.a, this.a + n10));
                return;
            }
            ksp.it.unimi.dsi.fastutil.objects.ObjectArrays$b.invokeAll(new b<Object>(objectArray, this.b - n2, this.b));
        }
    }

    protected static final class e<K>
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final int[] c;
        private final K[] d;

        public e(int[] nArray, K[] KArray, int n2, int n3) {
            this.a = n2;
            this.b = n3;
            this.d = KArray;
            this.c = nArray;
        }

        @Override
        protected final void compute() {
            int n2;
            Object[] objectArray = this.d;
            int n3 = this.b - this.a;
            if (n3 < 8192) {
                ObjectArrays.quickSortIndirect(this.c, objectArray, this.a, this.b);
                return;
            }
            int n4 = this.a + n3 / 2;
            int n5 = this.a;
            int n6 = this.b - 1;
            int n7 = n5;
            n5 = ObjectArrays.b(this.c, objectArray, n7, n7 + (n3 /= 8), n5 + 2 * n3);
            int n8 = n4;
            n4 = ObjectArrays.b(this.c, objectArray, n4 - n3, n8, n8 + n3);
            n6 = ObjectArrays.b(this.c, objectArray, n6 - 2 * n3, n6 - n3, n6);
            n4 = ObjectArrays.b(this.c, objectArray, n5, n4, n6);
            Object object = objectArray[this.c[n4]];
            n5 = n4 = this.a;
            int n9 = n6 = this.b - 1;
            while (true) {
                if (n5 <= n6 && (n2 = ((Comparable)objectArray[this.c[n5]]).compareTo(object)) <= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(this.c, n4++, n5);
                    }
                    ++n5;
                    continue;
                }
                while (n6 >= n5 && (n2 = ((Comparable)objectArray[this.c[n6]]).compareTo(object)) >= 0) {
                    if (n2 == 0) {
                        IntArrays.swap(this.c, n6, n9--);
                    }
                    --n6;
                }
                if (n5 > n6) break;
                IntArrays.swap(this.c, n5++, n6--);
            }
            int n10 = Math.min(n4 - this.a, n5 - n4);
            IntArrays.swap(this.c, this.a, n5 - n10, n10);
            n10 = Math.min(n9 - n6, this.b - n9 - 1);
            IntArrays.swap(this.c, n5, this.b - n10, n10);
            n10 = n5 - n4;
            n2 = n9 - n6;
            if (n10 > 1 && n2 > 1) {
                e.invokeAll(new e<Object>(this.c, objectArray, this.a, this.a + n10), new e<Object>(this.c, objectArray, this.b - n2, this.b));
                return;
            }
            if (n10 > 1) {
                e.invokeAll(new e<Object>(this.c, objectArray, this.a, this.a + n10));
                return;
            }
            e.invokeAll(new e<Object>(this.c, objectArray, this.b - n2, this.b));
        }
    }

    protected static final class c<K>
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        private final int a;
        private final int b;
        private final K[] c;
        private final K[] d;

        public c(K[] KArray, K[] KArray2, int n2, int n3) {
            this.a = n2;
            this.b = n3;
            this.c = KArray;
            this.d = KArray2;
        }

        @Override
        protected final void compute() {
            int n2;
            int n3;
            Object[] objectArray = this.c;
            Object[] objectArray2 = this.d;
            int n4 = this.b - this.a;
            if (n4 < 8192) {
                ObjectArrays.quickSort(objectArray, objectArray2, this.a, this.b);
                return;
            }
            int n5 = this.a + n4 / 2;
            int n6 = this.a;
            int n7 = this.b - 1;
            int n8 = n6;
            n6 = ObjectArrays.c(objectArray, objectArray2, n8, n8 + (n4 /= 8), n6 + 2 * n4);
            int n9 = n5;
            n5 = ObjectArrays.c(objectArray, objectArray2, n5 - n4, n9, n9 + n4);
            n7 = ObjectArrays.c(objectArray, objectArray2, n7 - 2 * n4, n7 - n4, n7);
            n5 = ObjectArrays.c(objectArray, objectArray2, n6, n5, n7);
            Object object = objectArray[n5];
            Object object2 = objectArray2[n5];
            n7 = n6 = this.a;
            int n10 = n3 = this.b - 1;
            while (true) {
                if (n7 <= n3 && (n2 = (n2 = ((Comparable)objectArray[n7]).compareTo(object)) == 0 ? ((Comparable)objectArray2[n7]).compareTo(object2) : n2) <= 0) {
                    if (n2 == 0) {
                        ObjectArrays.b(objectArray, objectArray2, n6++, n7);
                    }
                    ++n7;
                    continue;
                }
                while (n3 >= n7 && (n2 = (n2 = ((Comparable)objectArray[n3]).compareTo(object)) == 0 ? ((Comparable)objectArray2[n3]).compareTo(object2) : n2) >= 0) {
                    if (n2 == 0) {
                        ObjectArrays.b(objectArray, objectArray2, n3, n10--);
                    }
                    --n3;
                }
                if (n7 > n3) break;
                ObjectArrays.b(objectArray, objectArray2, n7++, n3--);
            }
            int n11 = Math.min(n6 - this.a, n7 - n6);
            ObjectArrays.d(objectArray, objectArray2, this.a, n7 - n11, n11);
            n11 = Math.min(n10 - n3, this.b - n10 - 1);
            ObjectArrays.d(objectArray, objectArray2, n7, this.b - n11, n11);
            n11 = n7 - n6;
            n2 = n10 - n3;
            if (n11 > 1 && n2 > 1) {
                ksp.it.unimi.dsi.fastutil.objects.ObjectArrays$c.invokeAll(new c<Object>(objectArray, objectArray2, this.a, this.a + n11), new c<Object>(objectArray, objectArray2, this.b - n2, this.b));
                return;
            }
            if (n11 > 1) {
                ksp.it.unimi.dsi.fastutil.objects.ObjectArrays$c.invokeAll(new c<Object>(objectArray, objectArray2, this.a, this.a + n11));
                return;
            }
            ksp.it.unimi.dsi.fastutil.objects.ObjectArrays$c.invokeAll(new c<Object>(objectArray, objectArray2, this.b - n2, this.b));
        }
    }

    private static final class a<K>
    implements Hash.Strategy<K[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private a() {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

