/*
 * Decompiled with CFR 0.152.
 */
package ksp.net.jpountz.lz4;

import java.nio.ByteBuffer;
import ksp.net.jpountz.lz4.LZ4Exception;
import ksp.net.jpountz.lz4.LZ4Factory;
import ksp.net.jpountz.lz4.LZ4JNI;
import ksp.net.jpountz.lz4.LZ4SafeDecompressor;
import ksp.net.jpountz.util.ByteBufferUtils;
import ksp.net.jpountz.util.SafeUtils;

final class LZ4JNISafeDecompressor
extends LZ4SafeDecompressor {
    public static final LZ4JNISafeDecompressor INSTANCE = new LZ4JNISafeDecompressor();
    private static LZ4SafeDecompressor SAFE_INSTANCE;

    LZ4JNISafeDecompressor() {
    }

    @Override
    public final int decompress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int maxDestLen) {
        SafeUtils.checkRange(src, srcOff, srcLen);
        SafeUtils.checkRange(dest, destOff, maxDestLen);
        int result2 = LZ4JNI.LZ4_decompress_safe(src, null, srcOff, srcLen, dest, null, destOff, maxDestLen);
        if (result2 < 0) {
            throw new LZ4Exception("Error decoding offset " + (srcOff - result2) + " of input buffer");
        }
        return result2;
    }

    @Override
    public int decompress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dest, int destOff, int maxDestLen) {
        ByteBufferUtils.checkNotReadOnly(dest);
        ByteBufferUtils.checkRange(src, srcOff, srcLen);
        ByteBufferUtils.checkRange(dest, destOff, maxDestLen);
        if ((src.hasArray() || src.isDirect()) && (dest.hasArray() || dest.isDirect())) {
            byte[] srcArr = null;
            byte[] destArr = null;
            ByteBuffer srcBuf = null;
            ByteBuffer destBuf = null;
            if (src.hasArray()) {
                srcArr = src.array();
                srcOff += src.arrayOffset();
            } else {
                assert (src.isDirect());
                srcBuf = src;
            }
            if (dest.hasArray()) {
                destArr = dest.array();
                destOff += dest.arrayOffset();
            } else {
                assert (dest.isDirect());
                destBuf = dest;
            }
            int result2 = LZ4JNI.LZ4_decompress_safe(srcArr, srcBuf, srcOff, srcLen, destArr, destBuf, destOff, maxDestLen);
            if (result2 < 0) {
                throw new LZ4Exception("Error decoding offset " + (srcOff - result2) + " of input buffer");
            }
            return result2;
        }
        LZ4SafeDecompressor safeInstance = SAFE_INSTANCE;
        if (safeInstance == null) {
            safeInstance = SAFE_INSTANCE = LZ4Factory.safeInstance().safeDecompressor();
        }
        return safeInstance.decompress(src, srcOff, srcLen, dest, destOff, maxDestLen);
    }
}

