/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import ksp.org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureCache;", "", "moduleResolveComponents", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "<init>", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "getFileStructure", "ktFile", "getCachedFileStructure", "low-level-api-fir"})
public final class FileStructureCache {
    @NotNull
    private final LLFirModuleResolveComponents moduleResolveComponents;
    @NotNull
    private final ConcurrentMap<KtFile, FileStructure> cache;

    public FileStructureCache(@NotNull LLFirModuleResolveComponents moduleResolveComponents) {
        Intrinsics.checkNotNullParameter((Object)moduleResolveComponents, (String)"moduleResolveComponents");
        this.moduleResolveComponents = moduleResolveComponents;
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"createConcurrentSoftKeySoftValueMap(...)");
        this.cache = concurrentMap;
    }

    @NotNull
    public final FileStructure getFileStructure(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        FileStructure fileStructure = this.cache.computeIfAbsent(ktFile, arg_0 -> FileStructureCache.getFileStructure$lambda$1(arg_0 -> FileStructureCache.getFileStructure$lambda$0(ktFile, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)fileStructure, (String)"computeIfAbsent(...)");
        return fileStructure;
    }

    @Nullable
    public final FileStructure getCachedFileStructure(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        return (FileStructure)this.cache.get(ktFile);
    }

    private static final FileStructure getFileStructure$lambda$0(KtFile $ktFile, FileStructureCache this$0, KtFile it) {
        return FileStructure.Companion.build($ktFile, this$0.moduleResolveComponents);
    }

    private static final FileStructure getFileStructure$lambda$1(Function1 $tmp0, Object p0) {
        return (FileStructure)$tmp0.invoke(p0);
    }
}

