/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.google.common.primitives.Longs;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eBL\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ:\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00130\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u0018J*\u0010\u0019\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00130\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u001aJ2\u0010\u001b\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00130\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/cli/jvm/compiler/jarfs/LargeDynamicMappedBuffer;", "", "dataSize", "", "mapBuffer", "Lkotlin/Function2;", "Ljava/nio/MappedByteBuffer;", "unmapBuffer", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "defaultByteOrder", "Ljava/nio/ByteOrder;", "<init>", "(JLkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Ljava/nio/ByteOrder;)V", "currentMappedBuffer", "currentStart", "currentEnd", "withMappedRange", "R", "start", "end", "body", "Lksp/org/jetbrains/kotlin/cli/jvm/compiler/jarfs/LargeDynamicMappedBuffer$Mapping;", "(JJLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withMappedTail", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withMappedRangeFrom", "(JLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "unmap", "Mapping", "cli-base"})
public final class LargeDynamicMappedBuffer {
    private final long dataSize;
    @NotNull
    private final Function2<Long, Long, MappedByteBuffer> mapBuffer;
    @NotNull
    private final Function1<MappedByteBuffer, Unit> unmapBuffer;
    @NotNull
    private final ByteOrder defaultByteOrder;
    @Nullable
    private MappedByteBuffer currentMappedBuffer;
    private long currentStart;
    private long currentEnd;

    public LargeDynamicMappedBuffer(long dataSize, @NotNull Function2<? super Long, ? super Long, ? extends MappedByteBuffer> mapBuffer, @NotNull Function1<? super MappedByteBuffer, Unit> unmapBuffer, @NotNull ByteOrder defaultByteOrder) {
        Intrinsics.checkNotNullParameter(mapBuffer, (String)"mapBuffer");
        Intrinsics.checkNotNullParameter(unmapBuffer, (String)"unmapBuffer");
        Intrinsics.checkNotNullParameter((Object)defaultByteOrder, (String)"defaultByteOrder");
        this.dataSize = dataSize;
        this.mapBuffer = mapBuffer;
        this.unmapBuffer = unmapBuffer;
        this.defaultByteOrder = defaultByteOrder;
    }

    public /* synthetic */ LargeDynamicMappedBuffer(long l2, Function2 function2, Function1 function1, ByteOrder byteOrder, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            ByteOrder byteOrder2 = ByteOrder.nativeOrder();
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"nativeOrder(...)");
            byteOrder = byteOrder2;
        }
        this(l2, (Function2<? super Long, ? super Long, ? extends MappedByteBuffer>)function2, (Function1<? super MappedByteBuffer, Unit>)function1, byteOrder);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized <R> R withMappedRange(long start, long end, @NotNull Function1<? super Mapping, ? extends R> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        long l2 = start + 1L;
        if (!((end <= this.dataSize ? l2 <= end : false) && end - start <= Integer.MAX_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long currentSize = Integer.MAX_VALUE;
        if (this.currentMappedBuffer == null || this.currentStart > start || this.currentEnd < end) {
            void it;
            if (this.dataSize <= Integer.MAX_VALUE) {
                this.currentStart = 0L;
                this.currentEnd = this.dataSize;
                currentSize = this.dataSize;
            } else if (start + (long)Integer.MAX_VALUE > this.dataSize) {
                this.currentStart = this.dataSize - (long)Integer.MAX_VALUE;
                this.currentEnd = this.dataSize;
            } else {
                this.currentStart = start;
                this.currentEnd = start + (long)Integer.MAX_VALUE;
            }
            this.unmap();
            Object object = this.mapBuffer.invoke((Object)this.currentStart, (Object)currentSize);
            MappedByteBuffer mappedByteBuffer = (MappedByteBuffer)object;
            LargeDynamicMappedBuffer largeDynamicMappedBuffer = this;
            boolean bl2 = false;
            it.order(this.defaultByteOrder);
            largeDynamicMappedBuffer.currentMappedBuffer = (MappedByteBuffer)object;
        }
        MappedByteBuffer mappedByteBuffer = this.currentMappedBuffer;
        Intrinsics.checkNotNull((Object)mappedByteBuffer);
        MappedByteBuffer buffer = mappedByteBuffer;
        if (!(this.currentStart <= start && this.currentEnd >= end && start - this.currentStart < Integer.MAX_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        buffer.position((int)(start - this.currentStart));
        return (R)body.invoke((Object)new Mapping(buffer, buffer.position()));
    }

    public final <R> R withMappedTail(@NotNull Function1<? super Mapping, ? extends R> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        long[] lArray = new long[]{this.dataSize, Integer.MAX_VALUE};
        long size = Longs.min(lArray);
        return this.withMappedRange(this.dataSize - size, this.dataSize, body);
    }

    public final <R> R withMappedRangeFrom(long start, @NotNull Function1<? super Mapping, ? extends R> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        if (!(start < this.dataSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long[] lArray = new long[]{this.dataSize - start, Integer.MAX_VALUE};
        long size = Longs.min(lArray);
        return this.withMappedRange(start, start + size, body);
    }

    public final void unmap() {
        MappedByteBuffer mappedByteBuffer = this.currentMappedBuffer;
        if (mappedByteBuffer != null) {
            this.unmapBuffer.invoke((Object)mappedByteBuffer);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/cli/jvm/compiler/jarfs/LargeDynamicMappedBuffer$Mapping;", "", "buffer", "Ljava/nio/MappedByteBuffer;", "baseOffset", "", "<init>", "(Ljava/nio/MappedByteBuffer;I)V", "order", "", "bo", "Ljava/nio/ByteOrder;", "getInt", "offset", "getLong", "", "getShort", "", "getBytes", "", "length", "endOffset", "cli-base"})
    public static final class Mapping {
        @NotNull
        private final MappedByteBuffer buffer;
        private final int baseOffset;

        public Mapping(@NotNull MappedByteBuffer buffer, int baseOffset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.buffer = buffer;
            this.baseOffset = baseOffset;
        }

        public final void order(@NotNull ByteOrder bo2) {
            Intrinsics.checkNotNullParameter((Object)bo2, (String)"bo");
            this.buffer.order(bo2);
        }

        public final int getInt(int offset) {
            return this.buffer.getInt(this.baseOffset + offset);
        }

        public final long getLong(int offset) {
            return this.buffer.getLong(this.baseOffset + offset);
        }

        public final short getShort(int offset) {
            return this.buffer.getShort(this.baseOffset + offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] getBytes(int offset, int length) {
            byte[] bytes = new byte[length];
            this.buffer.position(this.baseOffset + offset);
            try {
                this.buffer.get(bytes, 0, length);
                byte[] byArray = bytes;
                return byArray;
            }
            finally {
                this.buffer.position(this.baseOffset);
            }
        }

        public final int endOffset() {
            return this.buffer.capacity() - this.baseOffset;
        }
    }
}

