/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.codegen.optimization.common;

import java.util.List;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.codegen.AsmUtil;
import ksp.org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import ksp.org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import ksp.org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import ksp.org.jetbrains.org.objectweb.asm.Handle;
import ksp.org.jetbrains.org.objectweb.asm.Opcodes;
import ksp.org.jetbrains.org.objectweb.asm.Type;
import ksp.org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import ksp.org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import ksp.org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import ksp.org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

public class OptimizationBasicInterpreter
extends Interpreter<BasicValue>
implements Opcodes {
    public OptimizationBasicInterpreter() {
        super(589824);
    }

    @Override
    @Nullable
    public StrictBasicValue newValue(@Nullable Type type2) {
        if (type2 == null) {
            return StrictBasicValue.UNINITIALIZED_VALUE;
        }
        switch (type2.getSort()) {
            case 0: {
                return null;
            }
            case 5: {
                return StrictBasicValue.INT_VALUE;
            }
            case 6: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 7: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 8: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 1: {
                return StrictBasicValue.BOOLEAN_VALUE;
            }
            case 2: {
                return StrictBasicValue.CHAR_VALUE;
            }
            case 3: {
                return StrictBasicValue.BYTE_VALUE;
            }
            case 4: {
                return StrictBasicValue.SHORT_VALUE;
            }
            case 9: 
            case 10: {
                return new StrictBasicValue(type2);
            }
        }
        throw new IllegalArgumentException("Unknown type sort " + type2.getSort());
    }

    @Override
    public BasicValue newOperation(@NotNull AbstractInsnNode insn) throws AnalyzerException {
        if (insn == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(0);
        }
        switch (insn.getOpcode()) {
            case 1: {
                return StrictBasicValue.NULL_VALUE;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return StrictBasicValue.INT_VALUE;
            }
            case 9: 
            case 10: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 11: 
            case 12: 
            case 13: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 14: 
            case 15: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 16: 
            case 17: {
                return StrictBasicValue.INT_VALUE;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Integer) {
                    return StrictBasicValue.INT_VALUE;
                }
                if (cst instanceof Float) {
                    return StrictBasicValue.FLOAT_VALUE;
                }
                if (cst instanceof Long) {
                    return StrictBasicValue.LONG_VALUE;
                }
                if (cst instanceof Double) {
                    return StrictBasicValue.DOUBLE_VALUE;
                }
                if (cst instanceof String) {
                    return this.newValue(Type.getObjectType("java/lang/String"));
                }
                if (cst instanceof Type) {
                    int sort = ((Type)cst).getSort();
                    if (sort == 10 || sort == 9) {
                        return this.newValue(Type.getObjectType("java/lang/Class"));
                    }
                    if (sort == 11) {
                        return this.newValue(Type.getObjectType("java/lang/invoke/MethodType"));
                    }
                    throw new IllegalArgumentException("Illegal LDC constant " + cst);
                }
                if (cst instanceof Handle) {
                    return this.newValue(Type.getObjectType("java/lang/invoke/MethodHandle"));
                }
                throw new IllegalArgumentException("Illegal LDC constant " + cst);
            }
            case 178: {
                return this.newValue(Type.getType(((FieldInsnNode)insn).desc));
            }
            case 187: {
                return this.newValue(Type.getObjectType(((TypeInsnNode)insn).desc));
            }
        }
        throw new IllegalArgumentException("Unexpected instruction: " + InlineCodegenUtilsKt.getInsnOpcodeText(insn));
    }

    @Override
    public BasicValue copyOperation(@NotNull AbstractInsnNode insn, BasicValue value2) throws AnalyzerException {
        if (insn == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(1);
        }
        return value2;
    }

    @Override
    public BasicValue binaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2) throws AnalyzerException {
        if (insn == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(2);
        }
        if (value1 == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(3);
        }
        if (value2 == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(4);
        }
        switch (insn.getOpcode()) {
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return StrictBasicValue.INT_VALUE;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 50: {
                Type arrayType2 = value1.getType();
                if (arrayType2 != null && arrayType2.getSort() == 9) {
                    return new StrictBasicValue(AsmUtil.correctElementType(arrayType2));
                }
                return StrictBasicValue.NULL_VALUE;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return StrictBasicValue.INT_VALUE;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected instruction: " + InlineCodegenUtilsKt.getInsnOpcodeText(insn));
    }

    @Override
    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        return null;
    }

    @Override
    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values2) throws AnalyzerException {
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            return this.newValue(Type.getType(((MultiANewArrayInsnNode)insn).desc));
        }
        if (opcode == 186) {
            return this.newValue(Type.getReturnType(((InvokeDynamicInsnNode)insn).desc));
        }
        return this.newValue(Type.getReturnType(((MethodInsnNode)insn).desc));
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, BasicValue value2, BasicValue expected) throws AnalyzerException {
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: {
                return StrictBasicValue.INT_VALUE;
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: {
                return null;
            }
            case 180: {
                return this.newValue(Type.getType(((FieldInsnNode)insn).desc));
            }
            case 188: {
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        return this.newValue(Type.getType("[Z"));
                    }
                    case 5: {
                        return this.newValue(Type.getType("[C"));
                    }
                    case 8: {
                        return this.newValue(Type.getType("[B"));
                    }
                    case 9: {
                        return this.newValue(Type.getType("[S"));
                    }
                    case 10: {
                        return this.newValue(Type.getType("[I"));
                    }
                    case 6: {
                        return this.newValue(Type.getType("[F"));
                    }
                    case 7: {
                        return this.newValue(Type.getType("[D"));
                    }
                    case 11: {
                        return this.newValue(Type.getType("[J"));
                    }
                }
                throw new AnalyzerException(insn, "Invalid array type");
            }
            case 189: {
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getType("[" + Type.getObjectType(desc)));
            }
            case 190: {
                return StrictBasicValue.INT_VALUE;
            }
            case 191: {
                return null;
            }
            case 192: {
                if (value2 == StrictBasicValue.NULL_VALUE) {
                    return StrictBasicValue.NULL_VALUE;
                }
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getObjectType(desc));
            }
            case 193: {
                return StrictBasicValue.INT_VALUE;
            }
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected instruction: " + InlineCodegenUtilsKt.getInsnOpcodeText(insn));
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v2, @NotNull BasicValue w2) {
        if (v2 == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(5);
        }
        if (w2 == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(6);
        }
        if (v2.equals(w2)) {
            BasicValue basicValue = v2;
            if (basicValue == null) {
                OptimizationBasicInterpreter.$$$reportNull$$$0(7);
            }
            return basicValue;
        }
        if (v2 == StrictBasicValue.UNINITIALIZED_VALUE || w2 == StrictBasicValue.UNINITIALIZED_VALUE) {
            StrictBasicValue strictBasicValue = StrictBasicValue.UNINITIALIZED_VALUE;
            if (strictBasicValue == null) {
                OptimizationBasicInterpreter.$$$reportNull$$$0(8);
            }
            return strictBasicValue;
        }
        if (OptimizationBasicInterpreter.isReference(v2) && OptimizationBasicInterpreter.isReference(w2)) {
            if (v2 == StrictBasicValue.NULL_VALUE) {
                StrictBasicValue strictBasicValue = this.newValue(w2.getType());
                if (strictBasicValue == null) {
                    OptimizationBasicInterpreter.$$$reportNull$$$0(9);
                }
                return strictBasicValue;
            }
            if (w2 == StrictBasicValue.NULL_VALUE) {
                StrictBasicValue strictBasicValue = this.newValue(v2.getType());
                if (strictBasicValue == null) {
                    OptimizationBasicInterpreter.$$$reportNull$$$0(10);
                }
                return strictBasicValue;
            }
            BasicValue basicValue = this.mergeReferenceTypes(w2.getType(), v2.getType());
            if (basicValue == null) {
                OptimizationBasicInterpreter.$$$reportNull$$$0(11);
            }
            return basicValue;
        }
        if (v2.getType().getOpcode(54) == 54 && w2.getType().getOpcode(54) == 54) {
            StrictBasicValue strictBasicValue = StrictBasicValue.INT_VALUE;
            if (strictBasicValue == null) {
                OptimizationBasicInterpreter.$$$reportNull$$$0(12);
            }
            return strictBasicValue;
        }
        StrictBasicValue strictBasicValue = StrictBasicValue.UNINITIALIZED_VALUE;
        if (strictBasicValue == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(13);
        }
        return strictBasicValue;
    }

    private static boolean isReference(@NotNull BasicValue v2) {
        if (v2 == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(14);
        }
        return v2.getType().getSort() == 10 || v2.getType().getSort() == 9;
    }

    private BasicValue mergeReferenceTypes(@NotNull Type a2, @NotNull Type b2) {
        if (a2 == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(15);
        }
        if (b2 == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(16);
        }
        int arrayDimensions = 0;
        while (a2.getSort() == 9 && b2.getSort() == 9) {
            a2 = AsmUtil.correctElementType(a2);
            b2 = AsmUtil.correctElementType(b2);
            ++arrayDimensions;
        }
        if (arrayDimensions == 0) {
            return StrictBasicValue.REFERENCE_VALUE;
        }
        if (AsmUtil.isPrimitive(a2) || AsmUtil.isPrimitive(b2)) {
            // empty if block
        }
        StringBuilder result2 = new StringBuilder();
        while (true) {
            int n2 = --arrayDimensions;
            --arrayDimensions;
            if (n2 <= 0) break;
            result2.append("[");
        }
        result2.append(AsmTypes.OBJECT_TYPE.getDescriptor());
        return this.newValue(Type.getType(result2.toString()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value2";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newOperation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyOperation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "binaryOperation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReference";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeReferenceTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

