/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirGenericQualifierOnConstructorCallChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirGenericQualifierOnConstructorCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirGenericQualifierOnConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirGenericQualifierOnConstructorCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,32:1\n49#2:33\n*S KotlinDebug\n*F\n+ 1 FirGenericQualifierOnConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirGenericQualifierOnConstructorCallChecker\n*L\n25#1:33\n*E\n"})
public final class FirGenericQualifierOnConstructorCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirGenericQualifierOnConstructorCallChecker INSTANCE = new FirGenericQualifierOnConstructorCallChecker();

    private FirGenericQualifierOnConstructorCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression2) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirExpression firExpression = expression2.getExplicitReceiver();
        FirResolvedQualifier firResolvedQualifier = firExpression instanceof FirResolvedQualifier ? (FirResolvedQualifier)firExpression : null;
        if (firResolvedQualifier == null) {
            return;
        }
        FirResolvedQualifier resolvedQualifier = firResolvedQualifier;
        if (resolvedQualifier.getTypeArguments().isEmpty()) {
            return;
        }
        FirConstructorSymbol firConstructorSymbol = FirReferenceUtilsKt.toResolvedConstructorSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol constructorSymbol = firConstructorSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(constructorSymbol);
        if (firClassLikeSymbol != null) {
            FirClassLikeSymbol<?> $this$isInner$iv = firClassLikeSymbol;
            boolean $i$f$isInner = false;
            bl2 = !$this$isInner$iv.getRawStatus().isInner();
        } else {
            bl2 = false;
        }
        if (!bl2) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)resolvedQualifier.getSource(), FirErrors.INSTANCE.getGENERIC_QUALIFIER_ON_CONSTRUCTOR_CALL(), null, 8, null);
    }
}

