/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.backend;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.lang.LighterASTNode;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.util.diff.FlyweightCapableTreeStructure;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtPsiSourceElement;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;
import ksp.org.jetbrains.kotlin.psi.KtForExpression;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"isChildOfForLoop", "", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "operationToken", "Lksp/com/intellij/psi/tree/IElementType;", "getOperationToken", "(Lorg/jetbrains/kotlin/KtSourceElement;)Lcom/intellij/psi/tree/IElementType;", "fir2ir"})
public final class Fir2IrVisitorKt {
    public static final boolean isChildOfForLoop(@NotNull KtSourceElement $this$isChildOfForLoop) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)$this$isChildOfForLoop, (String)"<this>");
        if ($this$isChildOfForLoop instanceof KtPsiSourceElement) {
            bl2 = ((KtPsiSourceElement)$this$isChildOfForLoop).getPsi().getParent() instanceof KtForExpression;
        } else {
            LighterASTNode lighterASTNode = $this$isChildOfForLoop.getTreeStructure().getParent($this$isChildOfForLoop.getLighterASTNode());
            bl2 = Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)KtNodeTypes.FOR);
        }
        return bl2;
    }

    @Nullable
    public static final IElementType getOperationToken(@NotNull KtSourceElement $this$operationToken) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$operationToken, (String)"<this>");
        boolean bl2 = Intrinsics.areEqual((Object)$this$operationToken.getElementType(), (Object)KtNodeTypes.BINARY_EXPRESSION);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if ($this$operationToken instanceof KtPsiSourceElement) {
            PsiElement psiElement = ((KtPsiSourceElement)$this$operationToken).getPsi();
            KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
            object = ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null;
        } else {
            FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = $this$operationToken.getTreeStructure();
            LighterASTNode lighterASTNode = $this$operationToken.getLighterASTNode();
            IElementType iElementType = KtNodeTypes.OPERATION_REFERENCE;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"OPERATION_REFERENCE");
            object = LightTreePositioningStrategiesKt.findChildByType(flyweightCapableTreeStructure, lighterASTNode, iElementType);
            if (object == null || (object = object.getTokenType()) == null) {
                throw new IllegalStateException(("No operation reference for binary expression: " + $this$operationToken.getLighterASTNode()).toString());
            }
        }
        return object;
    }
}

