/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.interpreter.transformer;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import ksp.org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import ksp.org.jetbrains.kotlin.ir.interpreter.transformer.IrConstEvaluationContext;
import ksp.org.jetbrains.kotlin.ir.interpreter.transformer.IrConstExpressionTransformer;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/ir/interpreter/transformer/IrConstOnlyNecessaryTransformer;", "Lksp/org/jetbrains/kotlin/ir/interpreter/transformer/IrConstExpressionTransformer;", "context", "Lksp/org/jetbrains/kotlin/ir/interpreter/transformer/IrConstEvaluationContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstEvaluationContext;)V", "jsCodeFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "visitCall", "Lksp/org/jetbrains/kotlin/ir/IrElement;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "data", "Lksp/org/jetbrains/kotlin/ir/interpreter/transformer/IrConstExpressionTransformer$Data;", "visitGetField", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "Lksp/org/jetbrains/kotlin/ir/expressions/IrGetField;", "visitStringConcatenation", "Lksp/org/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitField", "Lksp/org/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrField;", "ir.interpreter"})
public final class IrConstOnlyNecessaryTransformer
extends IrConstExpressionTransformer {
    @NotNull
    private final FqName jsCodeFqName;

    public IrConstOnlyNecessaryTransformer(@NotNull IrConstEvaluationContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.jsCodeFqName = JsStandardClassIds.Callables.JsCode.asSingleFqName();
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrConstExpressionTransformer.Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean isJsCodeCall = Intrinsics.areEqual((Object)IrUtilsKt.getFqNameWhenAvailable(expression2.getSymbol().getOwner()), (Object)this.jsCodeFqName);
        if (isJsCodeCall) {
            expression2.transformChildren(this, IrConstExpressionTransformer.Data.copy$default(data, true, false, 2, null));
            return expression2;
        }
        boolean isConstGetter = UtilsKt.isConst(UtilsKt.getProperty(expression2.getSymbol().getOwner()));
        if (data.mustEvaluate() || isConstGetter) {
            return super.visitCall(expression2, IrConstExpressionTransformer.Data.copy$default(data, true, false, 2, null));
        }
        expression2.transformChildren(this, data);
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrConstExpressionTransformer.Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean isConst = UtilsKt.isConst(UtilsKt.getProperty((IrField)expression2.getSymbol().getOwner()));
        if (data.mustEvaluate() || isConst) {
            return super.visitGetField(expression2, IrConstExpressionTransformer.Data.copy$default(data, true, false, 2, null));
        }
        expression2.transformChildren(this, data);
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull IrConstExpressionTransformer.Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.mustEvaluate()) {
            return super.visitStringConcatenation(expression2, IrConstExpressionTransformer.Data.copy$default(data, true, false, 2, null));
        }
        expression2.transformChildren(this, data);
        return expression2;
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration2, @NotNull IrConstExpressionTransformer.Data data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean isConst = UtilsKt.isConst(UtilsKt.getProperty(declaration2));
        if (isConst) {
            return super.visitField(declaration2, IrConstExpressionTransformer.Data.copy$default(data, true, false, 2, null));
        }
        declaration2.transformChildren(this, data);
        return declaration2;
    }
}

