/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.js.backend.ast;

import java.util.List;
import ksp.com.intellij.util.SmartList;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsBlock;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsCatch;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsContext;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsStatement;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import ksp.org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import ksp.org.jetbrains.kotlin.js.util.AstUtil;

public class JsTry
extends SourceInfoAwareJsNode
implements JsStatement {
    private final List<JsCatch> catches;
    private JsBlock finallyBlock;
    private JsBlock tryBlock;

    public JsTry() {
        this.catches = new SmartList<JsCatch>();
    }

    public JsTry(JsBlock tryBlock, List<JsCatch> catches, @Nullable JsBlock finallyBlock) {
        this.tryBlock = tryBlock;
        this.catches = catches;
        this.finallyBlock = finallyBlock;
    }

    public JsTry(JsBlock tryBlock, @Nullable JsCatch jsCatch, @Nullable JsBlock finallyBlock) {
        this(tryBlock, new SmartList<JsCatch>(), finallyBlock);
        if (jsCatch != null) {
            this.catches.add(jsCatch);
        }
    }

    public List<JsCatch> getCatches() {
        return this.catches;
    }

    public JsBlock getFinallyBlock() {
        return this.finallyBlock;
    }

    public JsBlock getTryBlock() {
        return this.tryBlock;
    }

    public void setFinallyBlock(JsBlock block) {
        this.finallyBlock = block;
    }

    public void setTryBlock(JsBlock block) {
        this.tryBlock = block;
    }

    @Override
    public void accept(JsVisitor v2) {
        v2.visitTry(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.tryBlock);
        visitor2.acceptWithInsertRemove(this.catches);
        if (this.finallyBlock != null) {
            visitor2.accept(this.finallyBlock);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v2, JsContext ctx) {
        if (v2.visit(this, ctx)) {
            this.tryBlock = v2.acceptStatement(this.tryBlock);
            v2.acceptList(this.catches);
            if (this.finallyBlock != null) {
                this.finallyBlock = v2.acceptStatement(this.finallyBlock);
            }
        }
        v2.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsTry deepCopy() {
        JsBlock tryCopy = AstUtil.deepCopy(this.tryBlock);
        List<JsCatch> catchCopy = AstUtil.deepCopy(this.catches);
        JsBlock finallyCopy = AstUtil.deepCopy(this.finallyBlock);
        JsTry jsTry = (JsTry)new JsTry(tryCopy, catchCopy, finallyCopy).withMetadataFrom(this);
        if (jsTry == null) {
            JsTry.$$$reportNull$$$0(0);
        }
        return jsTry;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/org/jetbrains/kotlin/js/backend/ast/JsTry", "deepCopy"));
    }
}

