/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.name;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\nJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\b\u0010#\u001a\u00020!H\u0016J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0006H\u00c6\u0003J'\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00062\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0018\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u001a\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000f\u00a8\u0006-"}, d2={"Lksp/org/jetbrains/kotlin/name/ClassId;", "", "packageFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "relativeClassName", "isLocal", "", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Z)V", "topLevelName", "Lksp/org/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;)V", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getRelativeClassName", "()Z", "parentClassId", "getParentClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "shortClassName", "getShortClassName", "()Lorg/jetbrains/kotlin/name/Name;", "outerClassId", "getOuterClassId", "outermostClassId", "getOutermostClassId", "isNestedClass", "createNestedClassId", "name", "asSingleFqName", "startsWith", "segment", "asString", "", "asFqNameString", "toString", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "Companion", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nClassId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassId.kt\norg/jetbrains/kotlin/name/ClassId\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,141:1\n1#2:142\n233#3:143\n233#3:144\n*S KotlinDebug\n*F\n+ 1 ClassId.kt\norg/jetbrains/kotlin/name/ClassId\n*L\n37#1:143\n47#1:144\n*E\n"})
public final class ClassId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FqName packageFqName;
    @NotNull
    private final FqName relativeClassName;
    private final boolean isLocal;

    public ClassId(@NotNull FqName packageFqName, @NotNull FqName relativeClassName, boolean isLocal) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)relativeClassName, (String)"relativeClassName");
        this.packageFqName = packageFqName;
        this.relativeClassName = relativeClassName;
        this.isLocal = isLocal;
        boolean bl3 = bl2 = !this.relativeClassName.isRoot();
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Class name must not be root: " + this.packageFqName + (this.isLocal ? " (local)" : "");
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final FqName getRelativeClassName() {
        return this.relativeClassName;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    public ClassId(@NotNull FqName packageFqName, @NotNull Name topLevelName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)topLevelName, (String)"topLevelName");
        this(packageFqName, FqName.Companion.topLevel(topLevelName), false);
    }

    @Nullable
    public final ClassId getParentClassId() {
        ClassId classId;
        boolean condition$iv = this.isNestedClass();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl2 = false;
            classId = new ClassId(this.packageFqName, this.relativeClassName.parent(), this.isLocal);
        } else {
            classId = null;
        }
        return classId;
    }

    @NotNull
    public final Name getShortClassName() {
        return this.relativeClassName.shortName();
    }

    @Nullable
    public final ClassId getOuterClassId() {
        ClassId classId;
        FqName parent2 = this.relativeClassName.parent();
        boolean condition$iv = !parent2.isRoot();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl2 = false;
            classId = new ClassId(this.packageFqName, parent2, this.isLocal);
        } else {
            classId = null;
        }
        return classId;
    }

    @NotNull
    public final ClassId getOutermostClassId() {
        FqName name2 = this.relativeClassName;
        while (!name2.parent().isRoot()) {
            name2 = name2.parent();
        }
        return new ClassId(this.packageFqName, name2, false);
    }

    public final boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    @NotNull
    public final ClassId createNestedClassId(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new ClassId(this.packageFqName, this.relativeClassName.child(name2), this.isLocal);
    }

    @NotNull
    public final FqName asSingleFqName() {
        return this.packageFqName.isRoot() ? this.relativeClassName : new FqName(this.packageFqName.asString() + '.' + this.relativeClassName.asString());
    }

    public final boolean startsWith(@NotNull Name segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        return this.packageFqName.startsWith(segment);
    }

    @NotNull
    public final String asString() {
        String string;
        if (this.packageFqName.isRoot()) {
            string = ClassId.asString$escapeSlashes(this.relativeClassName);
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$asString_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$asString_u24lambda_u243.append(StringsKt.replace$default((String)this.packageFqName.asString(), (char)'.', (char)'/', (boolean)false, (int)4, null));
            $this$asString_u24lambda_u243.append("/");
            $this$asString_u24lambda_u243.append(ClassId.asString$escapeSlashes(this.relativeClassName));
            string = stringBuilder.toString();
        }
        return string;
    }

    @NotNull
    public final String asFqNameString() {
        String string;
        if (this.packageFqName.isRoot()) {
            string = this.relativeClassName.asString();
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$asFqNameString_u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$asFqNameString_u24lambda_u244.append(this.packageFqName.asString());
            $this$asFqNameString_u24lambda_u244.append(".");
            $this$asFqNameString_u24lambda_u244.append(this.relativeClassName.asString());
            string = stringBuilder.toString();
        }
        return string;
    }

    @NotNull
    public String toString() {
        return this.packageFqName.isRoot() ? '/' + this.asString() : this.asString();
    }

    @NotNull
    public final FqName component1() {
        return this.packageFqName;
    }

    @NotNull
    public final FqName component2() {
        return this.relativeClassName;
    }

    public final boolean component3() {
        return this.isLocal;
    }

    @NotNull
    public final ClassId copy(@NotNull FqName packageFqName, @NotNull FqName relativeClassName, boolean isLocal) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)relativeClassName, (String)"relativeClassName");
        return new ClassId(packageFqName, relativeClassName, isLocal);
    }

    public static /* synthetic */ ClassId copy$default(ClassId classId, FqName fqName, FqName fqName2, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            fqName = classId.packageFqName;
        }
        if ((n2 & 2) != 0) {
            fqName2 = classId.relativeClassName;
        }
        if ((n2 & 4) != 0) {
            bl2 = classId.isLocal;
        }
        return classId.copy(fqName, fqName2, bl2);
    }

    public int hashCode() {
        int result2 = this.packageFqName.hashCode();
        result2 = result2 * 31 + this.relativeClassName.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isLocal);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassId)) {
            return false;
        }
        ClassId classId = (ClassId)other;
        if (!Intrinsics.areEqual((Object)this.packageFqName, (Object)classId.packageFqName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.relativeClassName, (Object)classId.relativeClassName)) {
            return false;
        }
        return this.isLocal == classId.isLocal;
    }

    private static final String asString$escapeSlashes(FqName $this$asString_u24escapeSlashes) {
        String res2 = $this$asString_u24escapeSlashes.asString();
        if (StringsKt.contains$default((CharSequence)res2, (char)'/', (boolean)false, (int)2, null)) {
            return '`' + res2 + '`';
        }
        return res2;
    }

    @JvmStatic
    @NotNull
    public static final ClassId topLevel(@NotNull FqName topLevelFqName) {
        return Companion.topLevel(topLevelFqName);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ClassId fromString(@NotNull String string, boolean isLocal) {
        return Companion.fromString(string, isLocal);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ClassId fromString(@NotNull String string) {
        return Companion.fromString(string);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/name/ClassId$Companion;", "", "<init>", "()V", "topLevel", "Lksp/org/jetbrains/kotlin/name/ClassId;", "topLevelFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "fromString", "string", "", "isLocal", "", "compiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ClassId topLevel(@NotNull FqName topLevelFqName) {
            Intrinsics.checkNotNullParameter((Object)topLevelFqName, (String)"topLevelFqName");
            return new ClassId(topLevelFqName.parent(), topLevelFqName.shortName());
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ClassId fromString(@NotNull String string, boolean isLocal) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            int tickIndex = StringsKt.indexOf$default((CharSequence)string, (char)'`', (int)0, (boolean)false, (int)6, null);
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)string, (String)"/", (int)(tickIndex == -1 ? string.length() : tickIndex), (boolean)false, (int)4, null);
            String packageName2 = null;
            String className = null;
            if (lastSlashIndex == -1) {
                packageName2 = "";
                className = StringsKt.replace$default((String)string, (String)"`", (String)"", (boolean)false, (int)4, null);
            } else {
                String string2 = string.substring(0, lastSlashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                packageName2 = StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
                String string3 = string.substring(lastSlashIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                className = StringsKt.replace$default((String)string3, (String)"`", (String)"", (boolean)false, (int)4, null);
            }
            return new ClassId(new FqName(packageName2), new FqName(className), isLocal);
        }

        public static /* synthetic */ ClassId fromString$default(Companion companion, String string, boolean bl2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            return companion.fromString(string, bl2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ClassId fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            return ksp.org.jetbrains.kotlin.name.ClassId$Companion.fromString$default(this, string, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

