/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.FunctionExpressionDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtCallableDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtNamedDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import ksp.org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J*\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/resolve/checkers/UnderscoreChecker;", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "checkIdentifier", "", "identifier", "Lksp/com/intellij/psi/PsiElement;", "diagnosticHolder", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "allowSingleUnderscore", "", "checkNamed", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtNamedDeclaration;", "check", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lksp/org/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nUnderscoreChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnderscoreChecker.kt\norg/jetbrains/kotlin/resolve/checkers/UnderscoreChecker\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,80:1\n1069#2,2:81\n*S KotlinDebug\n*F\n+ 1 UnderscoreChecker.kt\norg/jetbrains/kotlin/resolve/checkers/UnderscoreChecker\n*L\n39#1:81,2\n*E\n"})
public final class UnderscoreChecker
implements DeclarationChecker {
    @NotNull
    public static final UnderscoreChecker INSTANCE = new UnderscoreChecker();

    private UnderscoreChecker() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmOverloads
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings, boolean allowSingleUnderscore) {
        boolean isValidSingleUnderscore;
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (identifier == null) return;
        String string = identifier.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            return;
        }
        boolean bl2 = false;
        if (bl2) {
            return;
        }
        boolean bl3 = isValidSingleUnderscore = allowSingleUnderscore && Intrinsics.areEqual((Object)identifier.getText(), (Object)"_");
        if (!isValidSingleUnderscore) {
            boolean bl4;
            block5: {
                String string2 = identifier.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                CharSequence $this$all$iv = string2;
                boolean $i$f$all = false;
                for (int i2 = 0; i2 < $this$all$iv.length(); ++i2) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i2);
                    boolean bl5 = false;
                    if (it == '_') continue;
                    bl4 = false;
                    break block5;
                }
                bl4 = true;
            }
            if (bl4) {
                diagnosticHolder.report(Errors.UNDERSCORE_IS_RESERVED.on(identifier));
                return;
            }
        }
        if (!isValidSingleUnderscore) return;
        if (languageVersionSettings.supportsFeature(LanguageFeature.SingleUnderscoreForParameterName)) return;
        diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(identifier, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.SingleUnderscoreForParameterName), (Object)languageVersionSettings)));
    }

    public static /* synthetic */ void checkIdentifier$default(UnderscoreChecker underscoreChecker, PsiElement psiElement, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        underscoreChecker.checkIdentifier(psiElement, diagnosticSink, languageVersionSettings, bl2);
    }

    @JvmOverloads
    public final void checkNamed(@NotNull KtNamedDeclaration declaration2, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings, boolean allowSingleUnderscore) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.checkIdentifier(declaration2.getNameIdentifier(), diagnosticHolder, languageVersionSettings, allowSingleUnderscore);
    }

    public static /* synthetic */ void checkNamed$default(UnderscoreChecker underscoreChecker, KtNamedDeclaration ktNamedDeclaration, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        underscoreChecker.checkNamed(ktNamedDeclaration, diagnosticSink, languageVersionSettings, bl2);
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (declaration2 instanceof KtProperty && !(descriptor2 instanceof VariableDescriptor)) {
            return;
        }
        if (declaration2 instanceof KtCallableDeclaration) {
            for (KtParameter parameter2 : ((KtCallableDeclaration)declaration2).getValueParameters()) {
                Intrinsics.checkNotNull((Object)parameter2);
                this.checkNamed(parameter2, context2.getTrace(), context2.getLanguageVersionSettings(), descriptor2 instanceof FunctionExpressionDescriptor);
            }
        }
        if (declaration2 instanceof KtTypeParameterListOwner) {
            for (KtTypeParameter typeParameter : ((KtTypeParameterListOwner)declaration2).getTypeParameters()) {
                Intrinsics.checkNotNull((Object)typeParameter);
                UnderscoreChecker.checkNamed$default(this, typeParameter, context2.getTrace(), context2.getLanguageVersionSettings(), false, 8, null);
            }
        }
        if (!(declaration2 instanceof KtNamedDeclaration)) {
            return;
        }
        UnderscoreChecker.checkNamed$default(this, (KtNamedDeclaration)declaration2, context2.getTrace(), context2.getLanguageVersionSettings(), false, 8, null);
    }

    @JvmOverloads
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        UnderscoreChecker.checkIdentifier$default(this, identifier, diagnosticHolder, languageVersionSettings, false, 8, null);
    }

    @JvmOverloads
    public final void checkNamed(@NotNull KtNamedDeclaration declaration2, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        UnderscoreChecker.checkNamed$default(this, declaration2, diagnosticHolder, languageVersionSettings, false, 8, null);
    }
}

