/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.promise.Promise;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class CustomElementRegistry {
  @JsFunction
  public interface DefineKlassCallbackFn {
    Object onInvoke();
  }

  @JsType
  public interface DefineOptionsType {
    @JsProperty
    String getExtends();

    @JsProperty
    void setExtends(String extends_);
  }

  @JsFunction
  public interface GetCallbackFn {
    Object onInvoke();
  }

  @JsFunction
  public interface WhenDefinedCallbackFn {
    Object onInvoke();
  }

  public native Object define(
      String tagName, DefineKlassCallbackFn klass, DefineOptionsType options);

  public native Object define(String tagName, DefineKlassCallbackFn klass);

  public native GetCallbackFn get(String tagName);

  public native Promise<WhenDefinedCallbackFn> whenDefined(String tagName);
}
