/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface MediaStreamTrack extends EventTarget {
  @JsFunction
  public interface OnendedCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnmuteCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnunmuteCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsMethod(name = "clone")
  MediaStreamTrack clone_();

  @JsProperty
  String getContentHint();

  @JsProperty
  String getId();

  @JsProperty
  String getKind();

  @JsProperty
  String getLabel();

  @JsProperty
  OnendedCallbackFn getOnended();

  @JsProperty
  OnmuteCallbackFn getOnmute();

  @JsProperty
  OnunmuteCallbackFn getOnunmute();

  @JsProperty
  String getReadyState();

  @JsProperty
  boolean isEnabled();

  @JsProperty
  boolean isMuted();

  @JsProperty
  boolean isRemote();

  @JsProperty
  void setContentHint(String contentHint);

  @JsProperty
  void setEnabled(boolean enabled);

  @JsProperty
  void setOnended(OnendedCallbackFn onended);

  @JsProperty
  void setOnmute(OnmuteCallbackFn onmute);

  @JsProperty
  void setOnunmute(OnunmuteCallbackFn onunmute);

  @JsProperty
  void setReadyState(String readyState);

  void stop();
}
