/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.promise.Promise;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import org.jspecify.annotations.Nullable;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class MediaStreamTrack implements EventTarget {
  @JsFunction
  public interface OnendedFn {
    @Nullable Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnmuteFn {
    @Nullable Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnoverconstrainedFn {
    @Nullable Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnunmuteFn {
    @Nullable Object onInvoke(Event p0);
  }

  public String contentHint;
  public boolean enabled;
  public String id;
  public String kind;
  public String label;
  public boolean muted;
  public MediaStreamTrack.@Nullable OnendedFn onended;
  public MediaStreamTrack.@Nullable OnmuteFn onmute;
  public MediaStreamTrack.@Nullable OnoverconstrainedFn onoverconstrained;
  public MediaStreamTrack.@Nullable OnunmuteFn onunmute;
  public String readyState;
  public boolean remote;

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType options);

  public native void addEventListener(String type, EventListener listener);

  public native Promise<Void> applyConstraints();

  public native Promise<Void> applyConstraints(@Nullable MediaTrackConstraints constraints);

  @JsMethod(name = "clone")
  public native MediaStreamTrack clone_();

  public native boolean dispatchEvent(Event evt);

  public native MediaTrackCapabilities getCapabilities();

  public native MediaTrackConstraints getConstraints();

  public native MediaTrackSettings getSettings();

  public native void removeEventListener(
      String type, EventListener listener, EventTarget.RemoveEventListenerOptionsUnionType options);

  public native void removeEventListener(String type, EventListener listener);

  public native void stop();
}
