/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.JsArray;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.jspecify.annotations.Nullable;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface MediaTrackConstraintSet {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetAspectRatioUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetAspectRatioUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainDoubleRange asConstrainDoubleRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetAutoGainControlUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetAutoGainControlUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default boolean asBoolean() {
      return Js.asBoolean(this);
    }

    @JsOverlay
    default @Nullable ConstrainBooleanParameters asConstrainBooleanParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBoolean() {
      return (Object) this instanceof Boolean;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetChannelCountUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetChannelCountUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainLongRange asConstrainLongRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default int asInt() {
      return Js.asInt(this);
    }

    @JsOverlay
    default boolean isInt() {
      return (Object) this instanceof Double;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetCursorUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetCursorUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainDOMStringParameters asConstrainDOMStringParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable JsArray<String> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetDeviceIdUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetDeviceIdUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainDOMStringParameters asConstrainDOMStringParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable JsArray<String> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetDisplaySurfaceUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetDisplaySurfaceUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainDOMStringParameters asConstrainDOMStringParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable JsArray<String> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetEchoCancellationUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetEchoCancellationUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default boolean asBoolean() {
      return Js.asBoolean(this);
    }

    @JsOverlay
    default @Nullable ConstrainBooleanParameters asConstrainBooleanParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBoolean() {
      return (Object) this instanceof Boolean;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetFacingModeUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetFacingModeUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainDOMStringParameters asConstrainDOMStringParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable JsArray<String> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetFrameRateUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetFrameRateUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainDoubleRange asConstrainDoubleRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetGroupIdUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetGroupIdUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainDOMStringParameters asConstrainDOMStringParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable JsArray<String> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetHeightUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetHeightUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainLongRange asConstrainLongRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default int asInt() {
      return Js.asInt(this);
    }

    @JsOverlay
    default boolean isInt() {
      return (Object) this instanceof Double;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetLatencyUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetLatencyUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainDoubleRange asConstrainDoubleRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetLogicalSurfaceUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetLogicalSurfaceUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default boolean asBoolean() {
      return Js.asBoolean(this);
    }

    @JsOverlay
    default @Nullable ConstrainBooleanParameters asConstrainBooleanParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBoolean() {
      return (Object) this instanceof Boolean;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetNoiseSuppressionUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetNoiseSuppressionUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default boolean asBoolean() {
      return Js.asBoolean(this);
    }

    @JsOverlay
    default @Nullable ConstrainBooleanParameters asConstrainBooleanParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBoolean() {
      return (Object) this instanceof Boolean;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetResizeModeUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetResizeModeUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainDOMStringParameters asConstrainDOMStringParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable JsArray<String> asJsArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default @Nullable String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isJsArray() {
      return (Object) this instanceof JsArray;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetRestrictOwnAudioUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetRestrictOwnAudioUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default boolean asBoolean() {
      return Js.asBoolean(this);
    }

    @JsOverlay
    default @Nullable ConstrainBooleanParameters asConstrainBooleanParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBoolean() {
      return (Object) this instanceof Boolean;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetSampleRateUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetSampleRateUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainLongRange asConstrainLongRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default int asInt() {
      return Js.asInt(this);
    }

    @JsOverlay
    default boolean isInt() {
      return (Object) this instanceof Double;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetSampleSizeUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetSampleSizeUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainLongRange asConstrainLongRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default int asInt() {
      return Js.asInt(this);
    }

    @JsOverlay
    default boolean isInt() {
      return (Object) this instanceof Double;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetSuppressLocalAudioPlaybackUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetSuppressLocalAudioPlaybackUnionType of(
        @Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default boolean asBoolean() {
      return Js.asBoolean(this);
    }

    @JsOverlay
    default @Nullable ConstrainBooleanParameters asConstrainBooleanParameters() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isBoolean() {
      return (Object) this instanceof Boolean;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetVolumeUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetVolumeUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainDoubleRange asConstrainDoubleRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetWidthUnionType {
    @JsOverlay
    static MediaTrackConstraintSet.@Nullable GetWidthUnionType of(@Nullable Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default @Nullable ConstrainLongRange asConstrainLongRange() {
      return Js.cast(this);
    }

    @JsOverlay
    default int asInt() {
      return Js.asInt(this);
    }

    @JsOverlay
    default boolean isInt() {
      return (Object) this instanceof Double;
    }
  }

  @JsOverlay
  static MediaTrackConstraintSet create() {
    return Js.uncheckedCast(JsPropertyMap.of());
  }

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetAspectRatioUnionType getAspectRatio();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetAutoGainControlUnionType getAutoGainControl();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetChannelCountUnionType getChannelCount();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetCursorUnionType getCursor();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetDeviceIdUnionType getDeviceId();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetDisplaySurfaceUnionType getDisplaySurface();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetEchoCancellationUnionType getEchoCancellation();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetFacingModeUnionType getFacingMode();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetFrameRateUnionType getFrameRate();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetGroupIdUnionType getGroupId();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetHeightUnionType getHeight();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetLatencyUnionType getLatency();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetLogicalSurfaceUnionType getLogicalSurface();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetNoiseSuppressionUnionType getNoiseSuppression();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetResizeModeUnionType getResizeMode();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetRestrictOwnAudioUnionType getRestrictOwnAudio();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetSampleRateUnionType getSampleRate();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetSampleSizeUnionType getSampleSize();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetSuppressLocalAudioPlaybackUnionType
      getSuppressLocalAudioPlayback();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetVolumeUnionType getVolume();

  @JsProperty
  MediaTrackConstraintSet.@Nullable GetWidthUnionType getWidth();

  @JsOverlay
  default void setAspectRatio(ConstrainDoubleRange aspectRatio) {
    setAspectRatio(
        Js.<MediaTrackConstraintSet.@Nullable GetAspectRatioUnionType>uncheckedCast(aspectRatio));
  }

  @JsProperty
  void setAspectRatio(MediaTrackConstraintSet.@Nullable GetAspectRatioUnionType aspectRatio);

  @JsOverlay
  default void setAspectRatio(double aspectRatio) {
    setAspectRatio(
        Js.<MediaTrackConstraintSet.@Nullable GetAspectRatioUnionType>uncheckedCast(aspectRatio));
  }

  @JsOverlay
  default void setAutoGainControl(ConstrainBooleanParameters autoGainControl) {
    setAutoGainControl(
        Js.<MediaTrackConstraintSet.@Nullable GetAutoGainControlUnionType>uncheckedCast(
            autoGainControl));
  }

  @JsProperty
  void setAutoGainControl(
      MediaTrackConstraintSet.@Nullable GetAutoGainControlUnionType autoGainControl);

  @JsOverlay
  default void setAutoGainControl(boolean autoGainControl) {
    setAutoGainControl(
        Js.<MediaTrackConstraintSet.@Nullable GetAutoGainControlUnionType>uncheckedCast(
            autoGainControl));
  }

  @JsOverlay
  default void setChannelCount(ConstrainLongRange channelCount) {
    setChannelCount(
        Js.<MediaTrackConstraintSet.@Nullable GetChannelCountUnionType>uncheckedCast(channelCount));
  }

  @JsProperty
  void setChannelCount(MediaTrackConstraintSet.@Nullable GetChannelCountUnionType channelCount);

  @JsOverlay
  default void setChannelCount(int channelCount) {
    setChannelCount(
        Js.<MediaTrackConstraintSet.@Nullable GetChannelCountUnionType>uncheckedCast(channelCount));
  }

  @JsOverlay
  default void setCursor(ConstrainDOMStringParameters cursor) {
    setCursor(Js.<MediaTrackConstraintSet.@Nullable GetCursorUnionType>uncheckedCast(cursor));
  }

  @JsProperty
  void setCursor(MediaTrackConstraintSet.@Nullable GetCursorUnionType cursor);

  @JsOverlay
  default void setCursor(JsArray<String> cursor) {
    setCursor(Js.<MediaTrackConstraintSet.@Nullable GetCursorUnionType>uncheckedCast(cursor));
  }

  @JsOverlay
  default void setCursor(String cursor) {
    setCursor(Js.<MediaTrackConstraintSet.@Nullable GetCursorUnionType>uncheckedCast(cursor));
  }

  @JsOverlay
  default void setCursor(String[] cursor) {
    setCursor(Js.<JsArray<String>>uncheckedCast(cursor));
  }

  @JsOverlay
  default void setDeviceId(ConstrainDOMStringParameters deviceId) {
    setDeviceId(Js.<MediaTrackConstraintSet.@Nullable GetDeviceIdUnionType>uncheckedCast(deviceId));
  }

  @JsProperty
  void setDeviceId(MediaTrackConstraintSet.@Nullable GetDeviceIdUnionType deviceId);

  @JsOverlay
  default void setDeviceId(JsArray<String> deviceId) {
    setDeviceId(Js.<MediaTrackConstraintSet.@Nullable GetDeviceIdUnionType>uncheckedCast(deviceId));
  }

  @JsOverlay
  default void setDeviceId(String deviceId) {
    setDeviceId(Js.<MediaTrackConstraintSet.@Nullable GetDeviceIdUnionType>uncheckedCast(deviceId));
  }

  @JsOverlay
  default void setDeviceId(String[] deviceId) {
    setDeviceId(Js.<JsArray<String>>uncheckedCast(deviceId));
  }

  @JsOverlay
  default void setDisplaySurface(ConstrainDOMStringParameters displaySurface) {
    setDisplaySurface(
        Js.<MediaTrackConstraintSet.@Nullable GetDisplaySurfaceUnionType>uncheckedCast(
            displaySurface));
  }

  @JsProperty
  void setDisplaySurface(
      MediaTrackConstraintSet.@Nullable GetDisplaySurfaceUnionType displaySurface);

  @JsOverlay
  default void setDisplaySurface(JsArray<String> displaySurface) {
    setDisplaySurface(
        Js.<MediaTrackConstraintSet.@Nullable GetDisplaySurfaceUnionType>uncheckedCast(
            displaySurface));
  }

  @JsOverlay
  default void setDisplaySurface(String displaySurface) {
    setDisplaySurface(
        Js.<MediaTrackConstraintSet.@Nullable GetDisplaySurfaceUnionType>uncheckedCast(
            displaySurface));
  }

  @JsOverlay
  default void setDisplaySurface(String[] displaySurface) {
    setDisplaySurface(Js.<JsArray<String>>uncheckedCast(displaySurface));
  }

  @JsOverlay
  default void setEchoCancellation(ConstrainBooleanParameters echoCancellation) {
    setEchoCancellation(
        Js.<MediaTrackConstraintSet.@Nullable GetEchoCancellationUnionType>uncheckedCast(
            echoCancellation));
  }

  @JsProperty
  void setEchoCancellation(
      MediaTrackConstraintSet.@Nullable GetEchoCancellationUnionType echoCancellation);

  @JsOverlay
  default void setEchoCancellation(boolean echoCancellation) {
    setEchoCancellation(
        Js.<MediaTrackConstraintSet.@Nullable GetEchoCancellationUnionType>uncheckedCast(
            echoCancellation));
  }

  @JsOverlay
  default void setFacingMode(ConstrainDOMStringParameters facingMode) {
    setFacingMode(
        Js.<MediaTrackConstraintSet.@Nullable GetFacingModeUnionType>uncheckedCast(facingMode));
  }

  @JsProperty
  void setFacingMode(MediaTrackConstraintSet.@Nullable GetFacingModeUnionType facingMode);

  @JsOverlay
  default void setFacingMode(JsArray<String> facingMode) {
    setFacingMode(
        Js.<MediaTrackConstraintSet.@Nullable GetFacingModeUnionType>uncheckedCast(facingMode));
  }

  @JsOverlay
  default void setFacingMode(String facingMode) {
    setFacingMode(
        Js.<MediaTrackConstraintSet.@Nullable GetFacingModeUnionType>uncheckedCast(facingMode));
  }

  @JsOverlay
  default void setFacingMode(String[] facingMode) {
    setFacingMode(Js.<JsArray<String>>uncheckedCast(facingMode));
  }

  @JsOverlay
  default void setFrameRate(ConstrainDoubleRange frameRate) {
    setFrameRate(
        Js.<MediaTrackConstraintSet.@Nullable GetFrameRateUnionType>uncheckedCast(frameRate));
  }

  @JsProperty
  void setFrameRate(MediaTrackConstraintSet.@Nullable GetFrameRateUnionType frameRate);

  @JsOverlay
  default void setFrameRate(double frameRate) {
    setFrameRate(
        Js.<MediaTrackConstraintSet.@Nullable GetFrameRateUnionType>uncheckedCast(frameRate));
  }

  @JsOverlay
  default void setGroupId(ConstrainDOMStringParameters groupId) {
    setGroupId(Js.<MediaTrackConstraintSet.@Nullable GetGroupIdUnionType>uncheckedCast(groupId));
  }

  @JsProperty
  void setGroupId(MediaTrackConstraintSet.@Nullable GetGroupIdUnionType groupId);

  @JsOverlay
  default void setGroupId(JsArray<String> groupId) {
    setGroupId(Js.<MediaTrackConstraintSet.@Nullable GetGroupIdUnionType>uncheckedCast(groupId));
  }

  @JsOverlay
  default void setGroupId(String groupId) {
    setGroupId(Js.<MediaTrackConstraintSet.@Nullable GetGroupIdUnionType>uncheckedCast(groupId));
  }

  @JsOverlay
  default void setGroupId(String[] groupId) {
    setGroupId(Js.<JsArray<String>>uncheckedCast(groupId));
  }

  @JsOverlay
  default void setHeight(ConstrainLongRange height) {
    setHeight(Js.<MediaTrackConstraintSet.@Nullable GetHeightUnionType>uncheckedCast(height));
  }

  @JsProperty
  void setHeight(MediaTrackConstraintSet.@Nullable GetHeightUnionType height);

  @JsOverlay
  default void setHeight(int height) {
    setHeight(Js.<MediaTrackConstraintSet.@Nullable GetHeightUnionType>uncheckedCast(height));
  }

  @JsOverlay
  default void setLatency(ConstrainDoubleRange latency) {
    setLatency(Js.<MediaTrackConstraintSet.@Nullable GetLatencyUnionType>uncheckedCast(latency));
  }

  @JsProperty
  void setLatency(MediaTrackConstraintSet.@Nullable GetLatencyUnionType latency);

  @JsOverlay
  default void setLatency(double latency) {
    setLatency(Js.<MediaTrackConstraintSet.@Nullable GetLatencyUnionType>uncheckedCast(latency));
  }

  @JsOverlay
  default void setLogicalSurface(ConstrainBooleanParameters logicalSurface) {
    setLogicalSurface(
        Js.<MediaTrackConstraintSet.@Nullable GetLogicalSurfaceUnionType>uncheckedCast(
            logicalSurface));
  }

  @JsProperty
  void setLogicalSurface(
      MediaTrackConstraintSet.@Nullable GetLogicalSurfaceUnionType logicalSurface);

  @JsOverlay
  default void setLogicalSurface(boolean logicalSurface) {
    setLogicalSurface(
        Js.<MediaTrackConstraintSet.@Nullable GetLogicalSurfaceUnionType>uncheckedCast(
            logicalSurface));
  }

  @JsOverlay
  default void setNoiseSuppression(ConstrainBooleanParameters noiseSuppression) {
    setNoiseSuppression(
        Js.<MediaTrackConstraintSet.@Nullable GetNoiseSuppressionUnionType>uncheckedCast(
            noiseSuppression));
  }

  @JsProperty
  void setNoiseSuppression(
      MediaTrackConstraintSet.@Nullable GetNoiseSuppressionUnionType noiseSuppression);

  @JsOverlay
  default void setNoiseSuppression(boolean noiseSuppression) {
    setNoiseSuppression(
        Js.<MediaTrackConstraintSet.@Nullable GetNoiseSuppressionUnionType>uncheckedCast(
            noiseSuppression));
  }

  @JsOverlay
  default void setResizeMode(ConstrainDOMStringParameters resizeMode) {
    setResizeMode(
        Js.<MediaTrackConstraintSet.@Nullable GetResizeModeUnionType>uncheckedCast(resizeMode));
  }

  @JsProperty
  void setResizeMode(MediaTrackConstraintSet.@Nullable GetResizeModeUnionType resizeMode);

  @JsOverlay
  default void setResizeMode(JsArray<String> resizeMode) {
    setResizeMode(
        Js.<MediaTrackConstraintSet.@Nullable GetResizeModeUnionType>uncheckedCast(resizeMode));
  }

  @JsOverlay
  default void setResizeMode(String resizeMode) {
    setResizeMode(
        Js.<MediaTrackConstraintSet.@Nullable GetResizeModeUnionType>uncheckedCast(resizeMode));
  }

  @JsOverlay
  default void setResizeMode(String[] resizeMode) {
    setResizeMode(Js.<JsArray<String>>uncheckedCast(resizeMode));
  }

  @JsOverlay
  default void setRestrictOwnAudio(ConstrainBooleanParameters restrictOwnAudio) {
    setRestrictOwnAudio(
        Js.<MediaTrackConstraintSet.@Nullable GetRestrictOwnAudioUnionType>uncheckedCast(
            restrictOwnAudio));
  }

  @JsProperty
  void setRestrictOwnAudio(
      MediaTrackConstraintSet.@Nullable GetRestrictOwnAudioUnionType restrictOwnAudio);

  @JsOverlay
  default void setRestrictOwnAudio(boolean restrictOwnAudio) {
    setRestrictOwnAudio(
        Js.<MediaTrackConstraintSet.@Nullable GetRestrictOwnAudioUnionType>uncheckedCast(
            restrictOwnAudio));
  }

  @JsOverlay
  default void setSampleRate(ConstrainLongRange sampleRate) {
    setSampleRate(
        Js.<MediaTrackConstraintSet.@Nullable GetSampleRateUnionType>uncheckedCast(sampleRate));
  }

  @JsProperty
  void setSampleRate(MediaTrackConstraintSet.@Nullable GetSampleRateUnionType sampleRate);

  @JsOverlay
  default void setSampleRate(int sampleRate) {
    setSampleRate(
        Js.<MediaTrackConstraintSet.@Nullable GetSampleRateUnionType>uncheckedCast(sampleRate));
  }

  @JsOverlay
  default void setSampleSize(ConstrainLongRange sampleSize) {
    setSampleSize(
        Js.<MediaTrackConstraintSet.@Nullable GetSampleSizeUnionType>uncheckedCast(sampleSize));
  }

  @JsProperty
  void setSampleSize(MediaTrackConstraintSet.@Nullable GetSampleSizeUnionType sampleSize);

  @JsOverlay
  default void setSampleSize(int sampleSize) {
    setSampleSize(
        Js.<MediaTrackConstraintSet.@Nullable GetSampleSizeUnionType>uncheckedCast(sampleSize));
  }

  @JsOverlay
  default void setSuppressLocalAudioPlayback(
      ConstrainBooleanParameters suppressLocalAudioPlayback) {
    setSuppressLocalAudioPlayback(
        Js.<MediaTrackConstraintSet.@Nullable GetSuppressLocalAudioPlaybackUnionType>uncheckedCast(
            suppressLocalAudioPlayback));
  }

  @JsProperty
  void setSuppressLocalAudioPlayback(
      MediaTrackConstraintSet.@Nullable GetSuppressLocalAudioPlaybackUnionType
          suppressLocalAudioPlayback);

  @JsOverlay
  default void setSuppressLocalAudioPlayback(boolean suppressLocalAudioPlayback) {
    setSuppressLocalAudioPlayback(
        Js.<MediaTrackConstraintSet.@Nullable GetSuppressLocalAudioPlaybackUnionType>uncheckedCast(
            suppressLocalAudioPlayback));
  }

  @JsOverlay
  default void setVolume(ConstrainDoubleRange volume) {
    setVolume(Js.<MediaTrackConstraintSet.@Nullable GetVolumeUnionType>uncheckedCast(volume));
  }

  @JsProperty
  void setVolume(MediaTrackConstraintSet.@Nullable GetVolumeUnionType volume);

  @JsOverlay
  default void setVolume(double volume) {
    setVolume(Js.<MediaTrackConstraintSet.@Nullable GetVolumeUnionType>uncheckedCast(volume));
  }

  @JsOverlay
  default void setWidth(ConstrainLongRange width) {
    setWidth(Js.<MediaTrackConstraintSet.@Nullable GetWidthUnionType>uncheckedCast(width));
  }

  @JsProperty
  void setWidth(MediaTrackConstraintSet.@Nullable GetWidthUnionType width);

  @JsOverlay
  default void setWidth(int width) {
    setWidth(Js.<MediaTrackConstraintSet.@Nullable GetWidthUnionType>uncheckedCast(width));
  }
}
