/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.jspecify.annotations.Nullable;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface MouseEventInit extends EventModifierInit {
  @JsOverlay
  static MouseEventInit create() {
    return Js.uncheckedCast(JsPropertyMap.of());
  }

  @JsProperty
  int getButton();

  @JsProperty
  int getButtons();

  @JsProperty
  double getClientX();

  @JsProperty
  double getClientY();

  @JsProperty
  @Nullable EventTarget getRelatedTarget();

  @JsProperty
  double getScreenX();

  @JsProperty
  double getScreenY();

  @JsProperty
  void setButton(int button);

  @JsProperty
  void setButtons(int buttons);

  @JsProperty
  void setClientX(double clientX);

  @JsProperty
  void setClientY(double clientY);

  @JsProperty
  void setRelatedTarget(@Nullable EventTarget relatedTarget);

  @JsProperty
  void setScreenX(double screenX);

  @JsProperty
  void setScreenY(double screenY);
}
