/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import org.jspecify.annotations.Nullable;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class RelatedEvent extends Event {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface RelatedEventEventInitDictType {
    @JsOverlay
    static RelatedEvent.RelatedEventEventInitDictType create() {
      return Js.uncheckedCast(JsPropertyMap.of());
    }

    @JsProperty
    @Nullable EventTarget getRelatedTarget();

    @JsProperty
    void setRelatedTarget(@Nullable EventTarget relatedTarget);
  }

  public @Nullable EventTarget relatedTarget;

  public RelatedEvent(String type, RelatedEvent.RelatedEventEventInitDictType eventInitDict) {
    // This super call is here only for the code to compile; it is never executed.
    super((String) null, (@Nullable EventInit) null);
  }

  public RelatedEvent(String type) {
    // This super call is here only for the code to compile; it is never executed.
    super((String) null, (@Nullable EventInit) null);
  }
}
