/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.promise.Promise;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import org.jspecify.annotations.Nullable;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class WorkerNavigator implements NavigatorBadge, NavigatorStorage {
  public double deviceMemory;
  public int hardwareConcurrency;
  public StorageManager storage;

  public native @Nullable Promise<Void> clearAppBadge();

  @JsProperty
  public native StorageManager getStorage();

  public native @Nullable Promise<Void> setAppBadge();

  public native @Nullable Promise<Void> setAppBadge(double contents);

  @JsProperty
  public native void setStorage(StorageManager storage);
}
