/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import elemental2.core.Float32Array;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioBuffer {
  public double duration;
  @Deprecated public AudioGain gain;
  public int length;
  public int numberOfChannels;
  public double sampleRate;

  public native Object copyFromChannel(
      Float32Array destination, int channelNumber, int startInChannel);

  public native Object copyFromChannel(Float32Array destination, int channelNumber);

  public native Object copyToChannel(Float32Array source, int channelNumber, int startInChannel);

  public native Object copyToChannel(Float32Array source, int channelNumber);

  public native Float32Array getChannelData(int channel);
}
