/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import elemental2.dom.Event;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioBufferSourceNode extends AudioNode {
  @JsFunction
  public interface OnendedFn {
    void onInvoke(Event p0);
  }

  @Deprecated public double FINISHED_STATE;
  @Deprecated public double PLAYING_STATE;
  @Deprecated public double SCHEDULED_STATE;
  @Deprecated public double UNSCHEDULED_STATE;
  public AudioBuffer buffer;
  public AudioParam detune;
  @Deprecated public double gain;
  public boolean loop;
  public double loopEnd;
  public double loopStart;
  public AudioBufferSourceNode.OnendedFn onended;
  public AudioParam playbackRate;
  @Deprecated public double playbackState;

  @Deprecated
  public native Object noteGrainOn();

  @Deprecated
  public native Object noteGrainOn(double when, double offset, double duration);

  @Deprecated
  public native Object noteGrainOn(double when, double offset);

  @Deprecated
  public native Object noteGrainOn(double when);

  @Deprecated
  public native Object noteOff(double when);

  @Deprecated
  public native void noteOn(double when);

  public native Object start();

  public native Object start(double when, double offset, double duration);

  public native Object start(double when, double offset);

  public native Object start(double when);

  public native Object stop();

  public native Object stop(double when);
}
