/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import elemental2.dom.HTMLMediaElement;
import elemental2.dom.MediaStream;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioContext extends BaseAudioContext {
  public AudioContext() {}

  public AudioContext(AudioContextOptions contextOptions) {}

  @Deprecated
  public native DelayNode createDelayNode();

  @Deprecated
  public native DelayNode createDelayNode(double maxDelayTime);

  @Deprecated
  public native GainNode createGainNode();

  @Deprecated
  public native ScriptProcessorNode createJavaScriptNode(
      int bufferSize, int numberOfInputs, int numberOfOuputs);

  public native MediaElementAudioSourceNode createMediaElementSource(HTMLMediaElement mediaElement);

  public native MediaStreamAudioDestinationNode createMediaStreamDestination();

  public native MediaStreamAudioSourceNode createMediaStreamSource(MediaStream mediaStream);
}
