/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface AudioContextOptions {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface GetLatencyHintUnionType {
    @JsOverlay
    static AudioContextOptions.GetLatencyHintUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.asDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.asString(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsOverlay
  static AudioContextOptions create() {
    return Js.uncheckedCast(JsPropertyMap.of());
  }

  @JsProperty
  AudioContextOptions.GetLatencyHintUnionType getLatencyHint();

  @JsProperty
  double getSampleRate();

  @JsProperty
  void setLatencyHint(AudioContextOptions.GetLatencyHintUnionType latencyHint);

  @JsOverlay
  default void setLatencyHint(String latencyHint) {
    setLatencyHint(Js.<AudioContextOptions.GetLatencyHintUnionType>uncheckedCast(latencyHint));
  }

  @JsOverlay
  default void setLatencyHint(double latencyHint) {
    setLatencyHint(Js.<AudioContextOptions.GetLatencyHintUnionType>uncheckedCast(latencyHint));
  }

  @JsProperty
  void setSampleRate(double sampleRate);
}
