/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import elemental2.core.Float32Array;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioParam {
  public String automationRate;
  public double defaultValue;
  @Deprecated public double maxValue;
  @Deprecated public double minValue;
  @Deprecated public double units;
  public double value;

  public native AudioParam cancelScheduledValues(double startTime);

  public native AudioParam exponentialRampToValueAtTime(double value, double endTime);

  public native AudioParam linearRampToValueAtTime(double value, double endTime);

  public native AudioParam setTargetAtTime(double target, double startTime, double timeConstant);

  @Deprecated
  public native AudioParam setTargetValueAtTime(
      double target, double startTime, double timeConstant);

  public native AudioParam setValueAtTime(double value, double startTime);

  public native AudioParam setValueCurveAtTime(
      Float32Array values, double startTime, double duration);
}
