/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import elemental2.core.JsArray;
import elemental2.core.Transferable;
import elemental2.dom.Event;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioWorkerNode extends AudioNode {
  @JsFunction
  public interface OnmessageFn {
    Object onInvoke(Event p0);
  }

  public AudioWorkerNode.OnmessageFn onmessage;

  public native Object postMessage(Object message, JsArray<Transferable> transfer);

  @JsOverlay
  public final Object postMessage(Object message, Transferable[] transfer) {
    return postMessage(message, Js.<JsArray<Transferable>>uncheckedCast(transfer));
  }

  public native Object postMessage(Object message);
}
