/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import elemental2.core.JsArray;
import elemental2.core.JsObject;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface AudioWorkletNodeOptions {
  @JsOverlay
  static AudioWorkletNodeOptions create() {
    return Js.uncheckedCast(JsPropertyMap.of());
  }

  @JsProperty
  double getNumberOfInputs();

  @JsProperty
  double getNumberOfOutputs();

  @JsProperty
  JsArray<Double> getOutputChannelCount();

  @JsProperty
  JsPropertyMap<Double> getParameterData();

  @JsProperty
  JsObject getProcessorOptions();

  @JsProperty
  void setNumberOfInputs(double numberOfInputs);

  @JsProperty
  void setNumberOfOutputs(double numberOfOutputs);

  @JsProperty
  void setOutputChannelCount(JsArray<Double> outputChannelCount);

  @JsOverlay
  default void setOutputChannelCount(double[] outputChannelCount) {
    setOutputChannelCount(Js.<JsArray<Double>>uncheckedCast(outputChannelCount));
  }

  @JsProperty
  void setParameterData(JsPropertyMap<Double> parameterData);

  @JsProperty
  void setProcessorOptions(JsObject processorOptions);

  @JsOverlay
  default void setProcessorOptions(Object processorOptions) {
    setProcessorOptions(Js.<JsObject>uncheckedCast(processorOptions));
  }
}
