/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import elemental2.core.Float32Array;
import elemental2.core.JsArray;
import elemental2.dom.MessagePort;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class AudioWorkletProcessor {
  public MessagePort port;

  public AudioWorkletProcessor() {}

  public AudioWorkletProcessor(AudioWorkletNodeOptions options) {}

  @JsOverlay
  public final boolean process(
      Float32Array[][] inputs, Float32Array[][] outputs, JsPropertyMap<Float32Array> parameters) {
    return process(
        Js.<JsArray<JsArray<Float32Array>>>uncheckedCast(inputs),
        Js.<JsArray<JsArray<Float32Array>>>uncheckedCast(outputs),
        parameters);
  }

  public native boolean process(
      JsArray<JsArray<Float32Array>> inputs,
      JsArray<JsArray<Float32Array>> outputs,
      JsPropertyMap<Float32Array> parameters);
}
