/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import elemental2.core.JsArray;
import elemental2.dom.Navigator;
import elemental2.promise.Promise;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, name = "Navigator", namespace = JsPackage.GLOBAL)
public class MediaNavigator extends Navigator {
  @JsOverlay
  public static MediaNavigator of(Navigator o) {
    return Js.cast(o);
  }

  public native Promise<MediaKeySystemAccess> requestMediaKeySystemAccess(
      String keySystem, JsArray<MediaKeySystemConfiguration> supportedConfigurations);

  @JsOverlay
  public final Promise<MediaKeySystemAccess> requestMediaKeySystemAccess(
      String keySystem, MediaKeySystemConfiguration[] supportedConfigurations) {
    return requestMediaKeySystemAccess(
        keySystem, Js.<JsArray<MediaKeySystemConfiguration>>uncheckedCast(supportedConfigurations));
  }
}
