/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import elemental2.dom.Event;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class OscillatorNode extends AudioNode {
  @JsFunction
  public interface OnendedFn {
    Object onInvoke(Event p0);
  }

  public AudioParam detune;
  public AudioParam frequency;
  public OscillatorNode.OnendedFn onended;
  @Deprecated public double playbackState;
  public String type;

  public native Object setPeriodicWave(PeriodicWave periodicWave);

  @Deprecated
  public native Object setWaveTable(WaveTable waveTable);

  public native Object start();

  public native Object start(double when);

  public native Object stop();

  public native Object stop(double when);
}
