/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.media;

import elemental2.dom.EventListener;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
@Deprecated
public class ScriptProcessorNode extends AudioNode {
  @JsFunction
  public interface OnaudioprocessFn {
    boolean onInvoke(AudioProcessingEvent p0);
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface OnaudioprocessUnionType {
    @JsOverlay
    static ScriptProcessorNode.OnaudioprocessUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default EventListener asEventListener() {
      return Js.cast(this);
    }

    @JsOverlay
    default ScriptProcessorNode.OnaudioprocessFn asOnaudioprocessFn() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isOnaudioprocessFn() {
      return (Object) this instanceof ScriptProcessorNode.OnaudioprocessFn;
    }
  }

  @Deprecated public int bufferSize;
  @Deprecated public ScriptProcessorNode.OnaudioprocessUnionType onaudioprocess;
}
