package elemental2.svg;

import elemental2.dom.CSSValue;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGDescElement extends SVGElement implements SVGLangSpace, SVGStylable {
  public SVGAnimatedString className;
  public String xmllang;
  public String xmlspace;

  @JsProperty
  public native SVGAnimatedString getClassName();

  public native CSSValue getPresentationAttribute();

  public native CSSValue getPresentationAttribute(String name);

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native void setXmlspace(String xmlspace);
}
