package elemental2.svg;

import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface SVGLocatable {
  SVGRect getBBox();

  SVGMatrix getCTM();

  @JsProperty
  SVGElement getFarthestViewportElement();

  @JsProperty
  SVGElement getNearestViewportElement();

  SVGMatrix getScreenCTM();

  SVGMatrix getTransformToElement();

  SVGMatrix getTransformToElement(SVGElement element);

  @JsProperty
  void setFarthestViewportElement(SVGElement farthestViewportElement);

  @JsProperty
  void setNearestViewportElement(SVGElement nearestViewportElement);
}
