/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGComponentTransferFunctionElement extends SVGElement {
  @JsOverlay
  public static final double SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE =
      SVGComponentTransferFunctionElement__Constants.SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE;

  @JsOverlay
  public static final double SVG_FECOMPONENTTRANSFER_TYPE_GAMMA =
      SVGComponentTransferFunctionElement__Constants.SVG_FECOMPONENTTRANSFER_TYPE_GAMMA;

  @JsOverlay
  public static final double SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY =
      SVGComponentTransferFunctionElement__Constants.SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY;

  @JsOverlay
  public static final double SVG_FECOMPONENTTRANSFER_TYPE_LINEAR =
      SVGComponentTransferFunctionElement__Constants.SVG_FECOMPONENTTRANSFER_TYPE_LINEAR;

  @JsOverlay
  public static final double SVG_FECOMPONENTTRANSFER_TYPE_TABLE =
      SVGComponentTransferFunctionElement__Constants.SVG_FECOMPONENTTRANSFER_TYPE_TABLE;

  @JsOverlay
  public static final double SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN =
      SVGComponentTransferFunctionElement__Constants.SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN;

  public SVGAnimatedNumber amplitude;
  public SVGAnimatedNumber exponent;
  public SVGAnimatedNumber intercept;
  public SVGAnimatedNumber offset;
  public SVGAnimatedNumber slope;
  public SVGAnimatedNumberList tableValues;
  public SVGAnimatedEnumeration type;
}
