/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import elemental2.dom.CSSValue;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGSymbolElement extends SVGElement
    implements SVGExternalResourcesRequired, SVGFitToViewBox, SVGLangSpace, SVGStylable {
  public SVGAnimatedBoolean externalResourcesRequired;
  public SVGAnimatedPreserveAspectRatio preserveAspectRatio;
  public SVGAnimatedRect viewBox;
  public String xmllang;
  public String xmlspace;

  @JsProperty
  public native SVGAnimatedString getClassName();

  @JsProperty
  public native SVGAnimatedBoolean getExternalResourcesRequired();

  public native CSSValue getPresentationAttribute();

  public native CSSValue getPresentationAttribute(String name);

  @JsProperty
  public native SVGAnimatedPreserveAspectRatio getPreserveAspectRatio();

  @JsProperty
  public native SVGAnimatedRect getViewBox();

  @JsProperty
  public native String getXmllang();

  @JsProperty
  public native String getXmlspace();

  @JsProperty
  public native void setClassName(SVGAnimatedString className);

  @JsProperty
  public native void setExternalResourcesRequired(SVGAnimatedBoolean externalResourcesRequired);

  @JsProperty
  public native void setPreserveAspectRatio(SVGAnimatedPreserveAspectRatio preserveAspectRatio);

  @JsProperty
  public native void setViewBox(SVGAnimatedRect viewBox);

  @JsProperty
  public native void setXmllang(String xmllang);

  @JsProperty
  public native void setXmlspace(String xmlspace);
}
