/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGTransform {
  @JsOverlay
  public static final double SVG_TRANSFORM_MATRIX = SVGTransform__Constants.SVG_TRANSFORM_MATRIX;

  @JsOverlay
  public static final double SVG_TRANSFORM_ROTATE = SVGTransform__Constants.SVG_TRANSFORM_ROTATE;

  @JsOverlay
  public static final double SVG_TRANSFORM_SCALE = SVGTransform__Constants.SVG_TRANSFORM_SCALE;

  @JsOverlay
  public static final double SVG_TRANSFORM_SKEWX = SVGTransform__Constants.SVG_TRANSFORM_SKEWX;

  @JsOverlay
  public static final double SVG_TRANSFORM_SKEWY = SVGTransform__Constants.SVG_TRANSFORM_SKEWY;

  @JsOverlay
  public static final double SVG_TRANSFORM_TRANSLATE =
      SVGTransform__Constants.SVG_TRANSFORM_TRANSLATE;

  @JsOverlay
  public static final double SVG_TRANSFORM_UNKNOWN = SVGTransform__Constants.SVG_TRANSFORM_UNKNOWN;

  public double angle;
  public SVGMatrix matrix;
  public int type;

  public native void setMatrix(SVGMatrix matrix);

  public native void setRotate(double angle, double cx, double cy);

  public native void setScale(double sx, double sy);

  public native void setSkewX(double angle);

  public native void setSkewY(double angle);

  public native void setTranslate(double tx, double ty);
}
