/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import elemental2.dom.CSSValue;
import elemental2.dom.RGBColor;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGColor extends CSSValue {
  @JsOverlay
  public static final double SVG_COLORTYPE_CURRENTCOLOR =
      SVGColor__Constants.SVG_COLORTYPE_CURRENTCOLOR;

  @JsOverlay
  public static final double SVG_COLORTYPE_RGBCOLOR = SVGColor__Constants.SVG_COLORTYPE_RGBCOLOR;

  @JsOverlay
  public static final double SVG_COLORTYPE_RGBCOLOR_ICCCOLOR =
      SVGColor__Constants.SVG_COLORTYPE_RGBCOLOR_ICCCOLOR;

  @JsOverlay
  public static final double SVG_COLORTYPE_UNKNOWN = SVGColor__Constants.SVG_COLORTYPE_UNKNOWN;

  public double colorType;
  public RGBColor rgbColor;

  public native void setColor(double colorType, String rgbColor, String iccColor);

  public native void setRGBColor(String rgbColor);

  public native void setRGBColorICCColor(String rgbColor, String iccColor);
}
