/*
 * Copyright 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.svg;

import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class SVGException {
  @JsOverlay
  public static final double SVG_INVALID_VALUE_ERR = SVGException__Constants.SVG_INVALID_VALUE_ERR;

  @JsOverlay
  public static final double SVG_MATRIX_NOT_INVERTABLE =
      SVGException__Constants.SVG_MATRIX_NOT_INVERTABLE;

  @JsOverlay
  public static final double SVG_WRONG_TYPE_ERR = SVGException__Constants.SVG_WRONG_TYPE_ERR;

  public double code;
  public String message;
  public String name;

  @JsMethod(name = "toString")
  public native String toString_();
}
